/*
 * Decompiled with CFR 0.152.
 */
package org.simphony;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Logger;
import org.protege.xmlcatalog.owlapi.XMLCatalogIRIMapper;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.formats.RDFXMLDocumentFormat;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologySetProvider;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.util.InferredClassAssertionAxiomGenerator;
import org.semanticweb.owlapi.util.InferredDataPropertyCharacteristicAxiomGenerator;
import org.semanticweb.owlapi.util.InferredEquivalentClassAxiomGenerator;
import org.semanticweb.owlapi.util.InferredEquivalentDataPropertiesAxiomGenerator;
import org.semanticweb.owlapi.util.InferredEquivalentObjectPropertyAxiomGenerator;
import org.semanticweb.owlapi.util.InferredInverseObjectPropertiesAxiomGenerator;
import org.semanticweb.owlapi.util.InferredObjectPropertyCharacteristicAxiomGenerator;
import org.semanticweb.owlapi.util.InferredOntologyGenerator;
import org.semanticweb.owlapi.util.InferredSubClassAxiomGenerator;
import org.semanticweb.owlapi.util.InferredSubDataPropertyAxiomGenerator;
import org.semanticweb.owlapi.util.InferredSubObjectPropertyAxiomGenerator;
import org.semanticweb.owlapi.util.OWLOntologyMerger;
import uk.ac.manchester.cs.factplusplus.owlapiv3.FaCTPlusPlusReasonerFactory;

public class OntologyLoader {
    private static final Logger LOGGER = Logger.getLogger(OntologyLoader.class.getName());
    private OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
    private OWLDataFactory dataFactory = OWLManager.getOWLDataFactory();
    private OWLOntology ontology;
    private IRI ontologyIRI;
    private File outputFile = new File("./_result_ontology.owl");

    public void loadOntologies(String[] args) {
        for (String arg : args) {
            try {
                File file = new File(arg);
                this.loadCatalog(file);
                this.ontology = this.manager.loadOntologyFromOntologyDocument(file);
            }
            catch (OWLOntologyCreationException e) {
                e.printStackTrace();
                LOGGER.warning("Could not load " + arg);
            }
        }
    }

    public void mergeOntologies() throws OWLOntologyCreationException {
        OWLOntologyManager newManager = OWLManager.createOWLOntologyManager();
        OWLOntologyMerger merger = new OWLOntologyMerger((OWLOntologySetProvider)this.manager);
        this.ontologyIRI = IRI.create((File)this.outputFile);
        this.ontology = merger.createMergedOntology(newManager, this.ontologyIRI);
        this.manager = newManager;
    }

    public void generateInferredAxioms() {
        FaCTPlusPlusReasonerFactory rf = new FaCTPlusPlusReasonerFactory();
        OWLReasoner reasoner = rf.createReasoner(this.ontology);
        ArrayList<Object> gens = new ArrayList<Object>();
        gens.add(new InferredSubClassAxiomGenerator());
        gens.add(new InferredClassAssertionAxiomGenerator());
        gens.add(new InferredEquivalentClassAxiomGenerator());
        gens.add(new InferredEquivalentDataPropertiesAxiomGenerator());
        gens.add(new InferredEquivalentObjectPropertyAxiomGenerator());
        gens.add(new InferredInverseObjectPropertiesAxiomGenerator());
        gens.add(new InferredObjectPropertyCharacteristicAxiomGenerator());
        gens.add(new InferredSubDataPropertyAxiomGenerator());
        gens.add(new InferredDataPropertyCharacteristicAxiomGenerator());
        gens.add(new InferredObjectPropertyCharacteristicAxiomGenerator());
        gens.add(new InferredSubObjectPropertyAxiomGenerator());
        InferredOntologyGenerator iog = new InferredOntologyGenerator(reasoner, gens);
        iog.fillOntology(this.dataFactory, this.ontology);
    }

    public void saveOntology() throws OWLOntologyStorageException {
        this.manager.saveOntology(this.ontology, (OWLDocumentFormat)new RDFXMLDocumentFormat());
    }

    private void loadCatalog(File owl_file) {
        File directory = owl_file.getParentFile();
        if (directory == null) {
            directory = new File(".");
        }
        for (String filename : directory.list()) {
            if (!filename.startsWith("catalog") || !filename.endsWith(".xml")) continue;
            try {
                File catalog = new File(directory, filename);
                XMLCatalogIRIMapper mapper = new XMLCatalogIRIMapper(catalog);
                this.manager.getIRIMappers().add((Serializable)mapper);
                LOGGER.info("Loaded catalog file " + catalog.toString());
            }
            catch (IOException e) {
                LOGGER.warning("Could not load catalog file " + filename);
            }
        }
    }

    public static void main(String[] args) throws IOException, OWLOntologyCreationException, OWLOntologyStorageException {
        OntologyLoader loader = new OntologyLoader();
        String command = args[0];
        loader.loadOntologies(Arrays.copyOfRange(args, 1, args.length));
        loader.mergeOntologies();
        System.out.println(command);
        if (command.equals("--run-reasoner")) {
            loader.generateInferredAxioms();
            System.out.println("Reasoner executed");
        }
        loader.saveOntology();
    }
}

