/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppcrt.sets;

import com.carrotsearch.hppcrt.ObjectContainer;
import com.carrotsearch.hppcrt.sets.ObjectHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectIdentityHashSet<KType>
extends ObjectHashSet<KType> {
    @Override
    protected int hashKey(KType key) {
        return System.identityHashCode(key);
    }

    @Override
    protected boolean equalKeys(KType a, KType b) {
        return a == b;
    }

    public ObjectIdentityHashSet() {
        this(8, 0.75);
    }

    public ObjectIdentityHashSet(int initialCapacity) {
        this(initialCapacity, 0.75);
    }

    public ObjectIdentityHashSet(int initialCapacity, double loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public ObjectIdentityHashSet(ObjectContainer<KType> container) {
        this(container.size());
        this.addAll(container);
    }

    @Override
    public ObjectIdentityHashSet<KType> clone() {
        ObjectIdentityHashSet<KType> cloned = new ObjectIdentityHashSet<KType>(this.size(), this.loadFactor);
        cloned.addAll(this);
        return cloned;
    }

    public static <KType> ObjectIdentityHashSet<KType> from(KType ... elements) {
        ObjectIdentityHashSet<KType> set = new ObjectIdentityHashSet<KType>(elements.length);
        set.add(elements);
        return set;
    }

    public static <KType> ObjectIdentityHashSet<KType> from(ObjectContainer<KType> container) {
        return new ObjectIdentityHashSet<KType>(container);
    }

    public static <KType> ObjectIdentityHashSet<KType> newInstance() {
        return new ObjectIdentityHashSet<KType>();
    }

    public static <KType> ObjectIdentityHashSet<KType> newInstance(int initialCapacity, double loadFactor) {
        return new ObjectIdentityHashSet<KType>(initialCapacity, loadFactor);
    }
}

