/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppcrt;

import com.carrotsearch.hppcrt.BufferAllocationException;
import com.carrotsearch.hppcrt.ByteCollection;
import com.carrotsearch.hppcrt.ByteLookupContainer;
import com.carrotsearch.hppcrt.cursors.ByteCursor;
import com.carrotsearch.hppcrt.predicates.BytePredicate;
import java.util.Arrays;

public abstract class AbstractByteCollection
implements ByteCollection {
    protected ByteLookupContainer testContainer;
    protected BytePredicate testPredicate;
    protected BytePredicate containsTestPredicate = new BytePredicate(){

        public final boolean apply(byte k) {
            return AbstractByteCollection.this.testContainer.contains(k);
        }
    };
    protected BytePredicate containsNegateTestPredicate = new BytePredicate(){

        public final boolean apply(byte k) {
            return !AbstractByteCollection.this.testContainer.contains(k);
        }
    };
    protected BytePredicate negatePredicate = new BytePredicate(){

        public final boolean apply(byte k) {
            return !AbstractByteCollection.this.testPredicate.apply(k);
        }
    };

    public int removeAll(ByteLookupContainer c) {
        this.testContainer = c;
        return this.removeAll(this.containsTestPredicate);
    }

    public int retainAll(ByteLookupContainer c) {
        this.testContainer = c;
        return this.removeAll(this.containsNegateTestPredicate);
    }

    public int retainAll(BytePredicate predicate) {
        this.testPredicate = predicate;
        return this.removeAll(this.negatePredicate);
    }

    public byte[] toArray(byte[] target) {
        assert (target.length >= this.size()) : "Target array must be >= " + this.size();
        int i = 0;
        for (ByteCursor c : this) {
            target[i++] = c.value;
        }
        return target;
    }

    public byte[] toArray() {
        try {
            return this.toArray(new byte[this.size()]);
        }
        catch (OutOfMemoryError e) {
            throw new BufferAllocationException("Not enough memory to allocate a '%s'.toArray() of  %d elements", (Throwable)e, this.getClass().toString(), this.size());
        }
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }
}

