/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.jdbc.$internal.okhttp3.internal.huc;

import io.prestosql.jdbc.$internal.okhttp3.MediaType;
import io.prestosql.jdbc.$internal.okhttp3.Request;
import io.prestosql.jdbc.$internal.okhttp3.RequestBody;
import io.prestosql.jdbc.$internal.okio.BufferedSink;
import io.prestosql.jdbc.$internal.okio.Timeout;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.ProtocolException;
import java.net.SocketTimeoutException;

abstract class OutputStreamRequestBody
extends RequestBody {
    private Timeout timeout;
    private long expectedContentLength;
    private OutputStream outputStream;
    boolean closed;

    OutputStreamRequestBody() {
    }

    protected void initOutputStream(final BufferedSink sink, final long expectedContentLength) {
        this.timeout = sink.timeout();
        this.expectedContentLength = expectedContentLength;
        this.outputStream = new OutputStream(){
            private long bytesReceived;

            @Override
            public void write(int b) throws IOException {
                this.write(new byte[]{(byte)b}, 0, 1);
            }

            @Override
            public void write(byte[] source, int offset, int byteCount) throws IOException {
                if (OutputStreamRequestBody.this.closed) {
                    throw new IOException("closed");
                }
                if (expectedContentLength != -1L && this.bytesReceived + (long)byteCount > expectedContentLength) {
                    throw new ProtocolException("expected " + expectedContentLength + " bytes but received " + this.bytesReceived + byteCount);
                }
                this.bytesReceived += (long)byteCount;
                try {
                    sink.write(source, offset, byteCount);
                }
                catch (InterruptedIOException e) {
                    throw new SocketTimeoutException(e.getMessage());
                }
            }

            @Override
            public void flush() throws IOException {
                if (OutputStreamRequestBody.this.closed) {
                    return;
                }
                sink.flush();
            }

            @Override
            public void close() throws IOException {
                OutputStreamRequestBody.this.closed = true;
                if (expectedContentLength != -1L && this.bytesReceived < expectedContentLength) {
                    throw new ProtocolException("expected " + expectedContentLength + " bytes but received " + this.bytesReceived);
                }
                sink.close();
            }
        };
    }

    public final OutputStream outputStream() {
        return this.outputStream;
    }

    public final Timeout timeout() {
        return this.timeout;
    }

    public final boolean isClosed() {
        return this.closed;
    }

    @Override
    public long contentLength() throws IOException {
        return this.expectedContentLength;
    }

    @Override
    public final MediaType contentType() {
        return null;
    }

    public Request prepareToSendRequest(Request request) throws IOException {
        return request;
    }
}

