/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.jdbc.$internal.airlift.json;

import com.google.inject.Binder;
import com.google.inject.TypeLiteral;
import com.google.inject.binder.LinkedBindingBuilder;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.multibindings.Multibinder;
import io.prestosql.jdbc.;
import io.prestosql.jdbc.$internal.guava.base.Preconditions;
import io.prestosql.jdbc.$internal.jackson.databind.JsonSerializer;
import java.util.Objects;

public class JsonBinder {
    private final MapBinder<Class<?>, JsonSerializer<?>> keySerializerMapBinder;
    private final MapBinder<Class<?>, .KeyDeserializer> keyDeserializerMapBinder;
    private final MapBinder<Class<?>, JsonSerializer<?>> serializerMapBinder;
    private final MapBinder<Class<?>, .JsonDeserializer<?>> deserializerMapBinder;
    private final Multibinder<.Module> moduleBinder;

    public static JsonBinder jsonBinder(Binder binder) {
        return new JsonBinder(binder);
    }

    private JsonBinder(Binder binder) {
        binder = Objects.requireNonNull(binder, "binder is null").skipSources(this.getClass());
        this.keySerializerMapBinder = MapBinder.newMapBinder(binder, new TypeLiteral<Class<?>>(){}, new TypeLiteral<JsonSerializer<?>>(){}, .JsonKeySerde.class);
        this.keyDeserializerMapBinder = MapBinder.newMapBinder(binder, new TypeLiteral<Class<?>>(){}, new TypeLiteral<.KeyDeserializer>(){}, .JsonKeySerde.class);
        this.serializerMapBinder = MapBinder.newMapBinder(binder, new TypeLiteral<Class<?>>(){}, new TypeLiteral<JsonSerializer<?>>(){});
        this.deserializerMapBinder = MapBinder.newMapBinder(binder, new TypeLiteral<Class<?>>(){}, new TypeLiteral<.JsonDeserializer<?>>(){});
        this.moduleBinder = Multibinder.newSetBinder(binder, .Module.class);
    }

    public LinkedBindingBuilder<JsonSerializer<?>> addKeySerializerBinding(Class<?> type) {
        Objects.requireNonNull(type, "type is null");
        return this.keySerializerMapBinder.addBinding(type);
    }

    public LinkedBindingBuilder<.KeyDeserializer> addKeyDeserializerBinding(Class<?> type) {
        Objects.requireNonNull(type, "type is null");
        return this.keyDeserializerMapBinder.addBinding(type);
    }

    public LinkedBindingBuilder<JsonSerializer<?>> addSerializerBinding(Class<?> type) {
        Objects.requireNonNull(type, "type is null");
        return this.serializerMapBinder.addBinding(type);
    }

    public LinkedBindingBuilder<.JsonDeserializer<?>> addDeserializerBinding(Class<?> type) {
        Objects.requireNonNull(type, "type is null");
        return this.deserializerMapBinder.addBinding(type);
    }

    public LinkedBindingBuilder<.Module> addModuleBinding() {
        return this.moduleBinder.addBinding();
    }

    public <T> void bindSerializer(JsonSerializer<T> jsonSerializer) {
        Objects.requireNonNull(jsonSerializer, "jsonSerializer is null");
        Class<T> type = jsonSerializer.handledType();
        Objects.requireNonNull(type, "jsonSerializer.handledType is null");
        Preconditions.checkArgument(type == Object.class, "jsonSerializer.handledType can not be Object.class");
        this.serializerMapBinder.addBinding(type).toInstance(jsonSerializer);
    }
}

