/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.partition.mpc.reader.input;

import com.treasuredata.partition.mpc.reader.LimitedReadableByteChannel;
import com.treasuredata.partition.mpc.reader.input.InputFile;
import com.treasuredata.spark.thirdparty.com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.StandardOpenOption;

public class SharedLocalInputFile
implements InputFile {
    private final File path;
    private final long fileSize;
    private FileChannel channel;

    public SharedLocalInputFile(File file) {
        this.path = file;
        this.fileSize = file.length();
    }

    @Override
    public ReadableByteChannel openChannel(long l, long l2) throws IOException {
        if (this.channel == null) {
            this.channel = FileChannel.open(this.path.toPath(), StandardOpenOption.READ);
        }
        SharedLimitedReadableByteChannel sharedLimitedReadableByteChannel = new SharedLimitedReadableByteChannel(this.channel, l, l2);
        return sharedLimitedReadableByteChannel;
    }

    @Override
    public long size() {
        return this.fileSize;
    }

    @Override
    public void close() throws IOException {
        if (this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    private class SharedLimitedReadableByteChannel
    extends LimitedReadableByteChannel {
        private long position;

        public SharedLimitedReadableByteChannel(FileChannel fileChannel, long l, long l2) {
            super(fileChannel, l2);
            Preconditions.checkArgument(l + l2 <= SharedLocalInputFile.this.fileSize, "Position(%d) with limit(%d) cannot exceed file size(%s/%d)", (Object)l, (Object)l2, (Object)SharedLocalInputFile.this.path.getAbsolutePath(), (Object)SharedLocalInputFile.this.fileSize);
            this.position = l;
        }

        @Override
        public int read(ByteBuffer byteBuffer) throws IOException {
            ((FileChannel)this.channel).position(this.position);
            int n = super.read(byteBuffer);
            if (n > 0) {
                this.position += (long)n;
            }
            return n;
        }

        @Override
        public void close() throws IOException {
        }
    }
}

