/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.partition.mpc.reader.columnar;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.msgpack.value.ValueType;

public class TypeConversionException
extends RuntimeException {
    private final ValueType expectedType;
    private final EnumMap<ValueType, Integer> foundTypes = new EnumMap(ValueType.class);
    private int overflowCount = 0;

    public TypeConversionException(ValueType valueType) {
        this.expectedType = valueType;
    }

    public void reportInvalidType(ValueType valueType) {
        if (!this.foundTypes.containsKey((Object)valueType)) {
            this.foundTypes.put(valueType, 0);
        }
        this.foundTypes.put(valueType, this.foundTypes.get((Object)valueType) + 1);
    }

    public void reportOverflow() {
        ++this.overflowCount;
    }

    @Override
    public String getMessage() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry<ValueType, Integer> entry : this.foundTypes.entrySet()) {
            arrayList.add(String.format("%s:%,d", new Object[]{entry.getKey(), entry.getValue()}));
        }
        if (this.foundTypes.isEmpty()) {
            return String.format("Type conversion error (expected: %s, observed overflows:%,d)", new Object[]{this.expectedType, this.overflowCount});
        }
        return String.format("Type conversion error (expected: %s, wrong type occurrences:[%s], observed overflows:%,d)", new Object[]{this.expectedType, TypeConversionException.mkString(arrayList, ", "), this.overflowCount});
    }

    private static <A> String mkString(List<A> list, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        for (A a : list) {
            if (n++ != 0) {
                stringBuilder.append(string);
            }
            if (a == null) {
                stringBuilder.append("null");
                continue;
            }
            if (a.getClass() == byte[].class) {
                stringBuilder.append(new String((byte[])a));
                continue;
            }
            stringBuilder.append(a.toString());
        }
        return stringBuilder.toString();
    }
}

