/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.partition.mpc.reader.columnar;

import com.treasuredata.partition.mpc.reader.columnar.AbstractColumnReader;
import com.treasuredata.partition.mpc.reader.columnar.ColumnReader;
import com.treasuredata.partition.mpc.reader.columnar.ColumnValueHolder;
import com.treasuredata.partition.mpc.reader.columnar.ColumnValueType;
import com.treasuredata.partition.mpc.reader.columnar.MPCColumnReader;
import com.treasuredata.spark.thirdparty.com.google.common.collect.ImmutableList;
import com.treasuredata.spark.thirdparty.com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.msgpack.core.MessageUnpacker;
import org.msgpack.value.Value;
import org.msgpack.value.ValueFactory;
import org.msgpack.value.ValueType;

public class MapColumnReader
extends AbstractColumnReader {
    private final MapHolder holder;

    public MapColumnReader(MessageUnpacker messageUnpacker, ColumnValueType columnValueType, ColumnValueType columnValueType2) {
        super(messageUnpacker);
        this.holder = new MapHolder(columnValueType, columnValueType2);
    }

    @Override
    protected MapHolder current() {
        return this.holder;
    }

    @Override
    public Map<?, ?> getMap() throws IOException {
        return this.holder.getOrElseUpdate();
    }

    @Override
    public int elementSize() throws IOException {
        return this.holder.getOrElseUpdateHeader();
    }

    @Override
    public Value getValue() throws IOException {
        if (this.isNull()) {
            return ValueFactory.newNil();
        }
        ImmutableMap.Builder<Value, Value> builder = ImmutableMap.builder();
        for (int i = 0; i < this.elementSize(); ++i) {
            builder.put(this.current().keyReader.getValue(), this.current().valueReader.getValue());
        }
        return ValueFactory.newMap(builder.build());
    }

    @Override
    public List<ColumnReader> getChildren() {
        return ImmutableList.of(this.holder.keyReader, this.holder.valueReader);
    }

    private class MapHolder
    extends ColumnValueHolder {
        private Map<Object, Object> mapValue;
        private final ColumnValueType keyType;
        private final ColumnValueType valueType;
        private final ColumnReader keyReader;
        private final ColumnReader valueReader;
        private int elementSize;

        public MapHolder(ColumnValueType columnValueType, ColumnValueType columnValueType2) {
            this.keyType = columnValueType;
            this.valueType = columnValueType2;
            this.keyReader = MPCColumnReader.createColumnReader(MapColumnReader.this.unpacker, columnValueType, false);
            this.valueReader = MPCColumnReader.createColumnReader(MapColumnReader.this.unpacker, columnValueType2, false);
        }

        @Override
        protected boolean update() throws IOException {
            if (!this.isRead) {
                ValueType valueType = MapColumnReader.this.unpacker.getNextFormat().getValueType();
                switch (valueType) {
                    case MAP: {
                        this.elementSize = MapColumnReader.this.unpacker.unpackMapHeader();
                        break;
                    }
                    case NIL: {
                        this.isValid = false;
                        MapColumnReader.this.unpacker.skipValue();
                        break;
                    }
                    default: {
                        this.isValid = false;
                        MapColumnReader.this.unpacker.skipValue();
                    }
                }
                this.isRead = true;
            }
            return this.isValid;
        }

        @Override
        public void reset() {
            super.reset();
            this.mapValue = null;
        }

        public Map<?, ?> getOrElseUpdate() throws IOException {
            this.update();
            if (this.isValid && this.mapValue == null) {
                this.mapValue = new HashMap<Object, Object>(this.elementSize);
                for (int i = 0; i < this.elementSize; ++i) {
                    Object object = MapHolder.readItem(this.keyReader, this.keyType);
                    Object object2 = MapHolder.readItem(this.valueReader, this.valueType);
                    if (object == null) continue;
                    this.mapValue.put(object, object2);
                }
            }
            return this.mapValue;
        }

        public int getOrElseUpdateHeader() throws IOException {
            return this.elementSize;
        }
    }
}

