/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.partition.mpc.reader.columnar;

import com.treasuredata.partition.mpc.reader.columnar.AbstractColumnReader;
import com.treasuredata.partition.mpc.reader.columnar.ColumnValueHolder;
import java.io.IOException;
import org.msgpack.core.MessageIntegerOverflowException;
import org.msgpack.core.MessageUnpacker;
import org.msgpack.value.Value;
import org.msgpack.value.ValueFactory;
import org.msgpack.value.ValueType;

public class LongColumnReader
extends AbstractColumnReader {
    private final LongHolder holder = new LongHolder();

    public LongColumnReader(MessageUnpacker messageUnpacker) {
        super(messageUnpacker);
    }

    @Override
    protected LongHolder current() {
        return this.holder;
    }

    @Override
    public long getLong() throws IOException {
        return this.holder.getOrElseUpdate();
    }

    @Override
    public double getDouble() throws IOException {
        return this.holder.getOrElseUpdate();
    }

    @Override
    public Value getValue() throws IOException {
        if (this.isNull()) {
            return ValueFactory.newNil();
        }
        return ValueFactory.newInteger(this.getLong());
    }

    private class LongHolder
    extends ColumnValueHolder {
        private long value;

        private LongHolder() {
        }

        @Override
        public boolean update() throws IOException {
            if (!this.isRead) {
                ValueType valueType = LongColumnReader.this.unpacker.getNextFormat().getValueType();
                switch (valueType) {
                    case INTEGER: {
                        try {
                            this.value = LongColumnReader.this.unpacker.unpackLong();
                        }
                        catch (MessageIntegerOverflowException messageIntegerOverflowException) {
                            this.isValid = false;
                        }
                        break;
                    }
                    case FLOAT: {
                        this.value = (long)LongColumnReader.this.unpacker.unpackDouble();
                        break;
                    }
                    case STRING: {
                        try {
                            this.value = Long.parseLong(LongColumnReader.this.unpacker.unpackString());
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.isValid = false;
                        }
                        break;
                    }
                    case BOOLEAN: {
                        this.value = LongColumnReader.this.unpacker.unpackBoolean() ? 1L : 0L;
                        break;
                    }
                    case NIL: {
                        this.isValid = false;
                        LongColumnReader.this.unpacker.skipValue();
                        break;
                    }
                    default: {
                        this.isValid = false;
                        LongColumnReader.this.unpacker.skipValue();
                    }
                }
                this.isRead = true;
            }
            return this.isValid;
        }

        public long getOrElseUpdate() throws IOException {
            this.update();
            return this.value;
        }
    }
}

