/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.partition.mpc.reader.columnar;

import com.treasuredata.partition.mpc.reader.columnar.AbstractColumnReader;
import com.treasuredata.partition.mpc.reader.columnar.ColumnValueHolder;
import java.io.IOException;
import org.msgpack.core.MessageUnpacker;
import org.msgpack.value.Value;

public class LazyValueColumnReader
extends AbstractColumnReader {
    private final LazyValueHolder holder = new LazyValueHolder();
    private final LazyOpener opener;
    private MessageUnpacker unpacker;

    public LazyValueColumnReader(LazyOpener lazyOpener) {
        super(null);
        this.opener = lazyOpener;
    }

    @Override
    protected MessageUnpacker getUnpacker() throws IOException {
        if (this.unpacker == null) {
            this.unpacker = this.opener.open();
        }
        return this.unpacker;
    }

    @Override
    protected LazyValueHolder current() {
        return this.holder;
    }

    @Override
    public Value getValue() throws IOException {
        return this.holder.getOrElseUpdate();
    }

    public static interface LazyOpener {
        public MessageUnpacker open() throws IOException;
    }

    private class LazyValueHolder
    extends ColumnValueHolder {
        private Value value;

        private LazyValueHolder() {
        }

        @Override
        protected boolean update() throws IOException {
            if (!this.isRead) {
                this.value = LazyValueColumnReader.this.getUnpacker().unpackValue();
                this.isRead = true;
            }
            return true;
        }

        public Value getOrElseUpdate() throws IOException {
            this.update();
            return this.value;
        }
    }
}

