/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.partition.mpc.reader.columnar;

import com.treasuredata.partition.mpc.reader.columnar.AbstractColumnReader;
import com.treasuredata.partition.mpc.reader.columnar.ColumnValueHolder;
import java.io.IOException;
import org.msgpack.core.MessageIntegerOverflowException;
import org.msgpack.core.MessageUnpacker;
import org.msgpack.value.Value;
import org.msgpack.value.ValueFactory;
import org.msgpack.value.ValueType;

public class DoubleColumnReader
extends AbstractColumnReader {
    private final DoubleHolder holder = new DoubleHolder();

    public DoubleColumnReader(MessageUnpacker messageUnpacker) {
        super(messageUnpacker);
    }

    @Override
    protected DoubleHolder current() {
        return this.holder;
    }

    @Override
    public long getLong() throws IOException {
        return (long)this.holder.getOrElseUpdate();
    }

    @Override
    public double getDouble() throws IOException {
        return this.holder.getOrElseUpdate();
    }

    @Override
    public Value getValue() throws IOException {
        if (this.isNull()) {
            return ValueFactory.newNil();
        }
        return ValueFactory.newFloat(this.getDouble());
    }

    private class DoubleHolder
    extends ColumnValueHolder {
        private double value;

        private DoubleHolder() {
        }

        @Override
        protected boolean update() throws IOException {
            if (!this.isRead) {
                ValueType valueType = DoubleColumnReader.this.unpacker.getNextFormat().getValueType();
                switch (valueType) {
                    case FLOAT: {
                        this.value = DoubleColumnReader.this.unpacker.unpackDouble();
                        break;
                    }
                    case INTEGER: {
                        try {
                            this.value = DoubleColumnReader.this.unpacker.unpackLong();
                        }
                        catch (MessageIntegerOverflowException messageIntegerOverflowException) {
                            this.value = messageIntegerOverflowException.getBigInteger().doubleValue();
                        }
                        break;
                    }
                    case STRING: {
                        try {
                            this.value = Double.parseDouble(DoubleColumnReader.this.unpacker.unpackString());
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.isValid = false;
                        }
                        break;
                    }
                    case NIL: {
                        this.isValid = false;
                        DoubleColumnReader.this.unpacker.skipValue();
                        break;
                    }
                    default: {
                        this.isValid = false;
                        DoubleColumnReader.this.unpacker.skipValue();
                    }
                }
                this.isRead = true;
            }
            return this.isValid;
        }

        public double getOrElseUpdate() throws IOException {
            this.update();
            return this.value;
        }
    }
}

