/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.partition.mpc.reader;

import com.treasuredata.partition.mpc.MPCFile;
import com.treasuredata.partition.mpc.reader.MPCFileReader;
import com.treasuredata.partition.mpc.reader.columnar.LazyValueColumnReader;
import com.treasuredata.partition.mpc.reader.input.InputFile;
import com.treasuredata.spark.thirdparty.com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.channels.Channels;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import java.util.zip.GZIPInputStream;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessageUnpacker;
import org.msgpack.value.Value;
import org.msgpack.value.ValueFactory;

class LazyMPCFileReader
extends MPCFileReader {
    private List<LazyValueColumnReader> columnReader;

    public LazyMPCFileReader(InputFile inputFile) throws IOException {
        this(inputFile, null);
    }

    public LazyMPCFileReader(InputFile inputFile, List<String> list) throws IOException {
        super(inputFile);
        ImmutableList.Builder builder = ImmutableList.builder();
        if (list == null || list.isEmpty()) {
            this.columns.stream().forEach(columnInfo -> builder.add(new LazyValueColumnReader(new ColumnOpener((MPCFile.ColumnInfo)columnInfo))));
        } else {
            ArrayList arrayList = new ArrayList();
            this.columns.stream().filter(columnInfo -> list.contains(new String(columnInfo.getName()))).forEach(columnInfo -> {
                arrayList.add(new String(columnInfo.getName()));
                builder.add(new LazyValueColumnReader(new ColumnOpener((MPCFile.ColumnInfo)columnInfo)));
            });
            this.kvs = new Value[arrayList.size() * 2];
            IntStream.range(0, arrayList.size()).forEach(n -> {
                this.kvs[n * 2] = ValueFactory.newString((String)arrayList.get(n));
            });
        }
        this.columnReader = builder.build();
    }

    @Override
    public Value next() throws IOException {
        for (int i = 0; i < this.columnReader.size(); ++i) {
            LazyValueColumnReader lazyValueColumnReader = this.columnReader.get(i);
            lazyValueColumnReader.advance();
            if (!lazyValueColumnReader.hasNext()) {
                return null;
            }
            this.kvs[i * 2 + 1] = lazyValueColumnReader.getValue();
        }
        if (this.kvs.length == 0) {
            return null;
        }
        return ValueFactory.newMap(this.kvs);
    }

    @Override
    public void close() throws Exception {
        for (LazyValueColumnReader lazyValueColumnReader : this.columnReader) {
            lazyValueColumnReader.close();
        }
        super.close();
    }

    private class ColumnOpener
    implements LazyValueColumnReader.LazyOpener {
        private MPCFile.ColumnInfo c;

        public ColumnOpener(MPCFile.ColumnInfo columnInfo) {
            this.c = columnInfo;
        }

        @Override
        public MessageUnpacker open() throws IOException {
            this.c.setOpened();
            return MessagePack.newDefaultUnpacker(new GZIPInputStream(Channels.newInputStream(LazyMPCFileReader.this.input.openChannel(this.c.getOffset(), this.c.getSize()))));
        }
    }
}

