/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.partition.mpc.reader;

import com.treasuredata.partition.mpc.MPCFile;
import com.treasuredata.partition.mpc.reader.MPCFileReader;
import com.treasuredata.partition.mpc.reader.input.InputFile;
import com.treasuredata.spark.thirdparty.com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.channels.Channels;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessagePackException;
import org.msgpack.core.MessageUnpacker;
import org.msgpack.value.Value;
import org.msgpack.value.ValueFactory;

class EagerMPCFileReader
extends MPCFileReader {
    private final List<MessageUnpacker> columnReader;

    public EagerMPCFileReader(InputFile inputFile) throws IOException, MessagePackException {
        super(inputFile);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (MPCFile.ColumnInfo columnInfo : this.columns) {
            builder.add(MessagePack.newDefaultUnpacker(new GZIPInputStream(Channels.newInputStream(inputFile.openChannel(columnInfo.getOffset(), columnInfo.getSize())))));
        }
        this.columnReader = builder.build();
    }

    @Override
    public Value next() throws IOException, MessagePackException {
        for (int i = 0; i < this.columns.size(); ++i) {
            MessageUnpacker messageUnpacker = this.columnReader.get(i);
            if (!messageUnpacker.hasNext()) {
                return null;
            }
            this.kvs[i * 2 + 1] = messageUnpacker.unpackValue();
        }
        if (this.kvs.length == 0) {
            return null;
        }
        return ValueFactory.newMap(this.kvs);
    }

    @Override
    public void close() throws Exception, MessagePackException {
        IOException iOException = null;
        for (MessageUnpacker messageUnpacker : this.columnReader) {
            try {
                messageUnpacker.close();
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
        }
        if (iOException != null) {
            throw iOException;
        }
        super.close();
    }
}

