/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.partition.mpc.merge;

import com.treasuredata.partition.mpc.Column;
import com.treasuredata.partition.mpc.ColumnSet;
import com.treasuredata.partition.mpc.CompressionType;
import com.treasuredata.partition.mpc.merge.TimeIndexData;
import com.treasuredata.partition.mpc.writer.MPCFileWriter;
import com.treasuredata.partition.mpc.writer.TempFileAllocator;
import com.treasuredata.partition.mpc.writer.sparse.SparseTableBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import org.msgpack.value.Value;

public class TimeIndexMPCFileWriter
extends MPCFileWriter {
    private static final SparseTableBuilder NOP_SPARSE_TABLE_BUILDER;
    private ColumnSet columnSet;
    private final TimeIndexData timeIndexData;

    public TimeIndexMPCFileWriter(List<Value> list, TempFileAllocator tempFileAllocator) throws IOException {
        this(list, tempFileAllocator, new Column.FileSizeComparator(), new TimeIndexData());
    }

    public TimeIndexMPCFileWriter(List<Value> list, TempFileAllocator tempFileAllocator, TimeIndexData timeIndexData) throws IOException {
        this(list, tempFileAllocator, new Column.FileSizeComparator(), timeIndexData);
    }

    public TimeIndexMPCFileWriter(List<Value> list, TempFileAllocator tempFileAllocator, Comparator<Column> comparator) throws IOException {
        this(list, tempFileAllocator, comparator, new TimeIndexData());
    }

    public TimeIndexMPCFileWriter(List<Value> list, TempFileAllocator tempFileAllocator, Comparator<Column> comparator, TimeIndexData timeIndexData) throws IOException {
        super(CompressionType.GZIP, tempFileAllocator, comparator);
        this.timeIndexData = timeIndexData;
        for (Value value : list) {
            this.columnSet.get(value);
        }
    }

    @Override
    protected ColumnSet createColumnSet() {
        this.columnSet = super.createColumnSet();
        return this.columnSet;
    }

    @Override
    protected SparseTableBuilder createSparseTableBuilder() {
        return NOP_SPARSE_TABLE_BUILDER;
    }

    public void withColumnSet(Consumer<ColumnSet> consumer) {
        consumer.accept(this.columnSet);
    }

    @Override
    public long getRecordCount() {
        return this.timeIndexData.getRecordCount();
    }

    public void addRecordCount(long l) {
        this.timeIndexData.addRecordCount(l);
    }

    public void updateIndexRange(long l) {
        this.timeIndexData.updateIndexRange(l);
    }

    public long getFirstIndexKey() {
        return this.timeIndexData.getFirstIndexKey();
    }

    public long getLastIndexKey() {
        return this.timeIndexData.getLastIndexKey();
    }

    static {
        try {
            NOP_SPARSE_TABLE_BUILDER = new SparseTableBuilder(Files.createTempFile("sparse-vector-", "tmp", new FileAttribute[0]).toFile());
            NOP_SPARSE_TABLE_BUILDER.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }
}

