/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.partition.mpc.merge;

import com.treasuredata.partition.mpc.Column;
import com.treasuredata.partition.mpc.MPCFile;
import com.treasuredata.partition.mpc.merge.KeepOpenByteChannel;
import com.treasuredata.partition.mpc.merge.NopBlockBuilder;
import com.treasuredata.partition.mpc.merge.TimeIndexMPCFileWriter;
import com.treasuredata.partition.mpc.writer.TempFileAllocator;
import com.treasuredata.spark.thirdparty.com.google.common.base.Preconditions;
import com.treasuredata.spark.thirdparty.com.google.common.collect.ImmutableList;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessagePacker;
import org.msgpack.core.MessageUnpacker;
import org.msgpack.value.ImmutableBinaryValue;
import org.msgpack.value.ImmutableValue;
import org.msgpack.value.Value;
import org.msgpack.value.ValueFactory;

public class SplitMPCFileColumnsPacker
implements Closeable {
    private final TempFileAllocator tempFileAllocator;
    private final List<TimeIndexMPCFileWriter> writers;

    public SplitMPCFileColumnsPacker(TempFileAllocator tempFileAllocator) {
        this.tempFileAllocator = Objects.requireNonNull(tempFileAllocator, "tempFileAllocator is null");
        this.writers = new ArrayList<TimeIndexMPCFileWriter>();
    }

    public List<TimeIndexMPCFileWriter> extract(Supplier<TimeIndexMPCFileWriter> supplier, File file, long[] lArray) throws IOException {
        Preconditions.checkState(file.exists() && file.canRead(), "cannot access local file: " + file.getAbsolutePath());
        try (SeekableByteChannel seekableByteChannel = Files.newByteChannel(file.toPath(), StandardOpenOption.READ);){
            MPCFile.HeaderAndColumnInfo headerAndColumnInfo = MPCFile.readHeaderAndColumnInfo(seekableByteChannel, file.length());
            for (MPCFile.ColumnInfo columnInfo : headerAndColumnInfo.getColumnList()) {
                ImmutableBinaryValue immutableBinaryValue = ValueFactory.newBinary(columnInfo.getName());
                seekableByteChannel.position(columnInfo.getOffset());
                MessageUnpacker messageUnpacker = MessagePack.newDefaultUnpacker(new GZIPInputStream(Channels.newInputStream(new KeepOpenByteChannel(seekableByteChannel, columnInfo.getSize()))));
                Throwable throwable = null;
                try {
                    this.writeColumn(supplier, immutableBinaryValue, messageUnpacker, lArray);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (messageUnpacker == null) continue;
                    if (throwable != null) {
                        try {
                            messageUnpacker.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    messageUnpacker.close();
                }
            }
        }
        return ImmutableList.copyOf(this.writers);
    }

    private void writeColumn(Supplier<TimeIndexMPCFileWriter> supplier, Value value, MessageUnpacker messageUnpacker, long[] lArray) throws IOException {
        boolean bl = ValueFactory.newBinary("time".getBytes(StandardCharsets.UTF_8)).equals(value);
        for (int i = 0; i < lArray.length; ++i) {
            TimeIndexMPCFileWriter timeIndexMPCFileWriter;
            if (this.writers.size() <= i) {
                timeIndexMPCFileWriter = supplier.get();
                timeIndexMPCFileWriter.addRecordCount(lArray[i]);
                this.writers.add(timeIndexMPCFileWriter);
            }
            timeIndexMPCFileWriter = this.writers.get(i);
            try (MessagePacker messagePacker = this.newColumnPacker(timeIndexMPCFileWriter, value);){
                for (long j = timeIndexMPCFileWriter.getRecordCount(); j > 0L && messageUnpacker.hasNext(); --j) {
                    ImmutableValue immutableValue = messageUnpacker.unpackValue();
                    messagePacker.packValue(immutableValue);
                    if (!bl) continue;
                    timeIndexMPCFileWriter.updateIndexRange(immutableValue.asNumberValue().toLong());
                }
                continue;
            }
        }
    }

    public List<TimeIndexMPCFileWriter> finish() throws IOException {
        for (TimeIndexMPCFileWriter timeIndexMPCFileWriter : this.writers) {
            timeIndexMPCFileWriter.finish();
        }
        return ImmutableList.copyOf(this.writers);
    }

    private MessagePacker newColumnPacker(TimeIndexMPCFileWriter timeIndexMPCFileWriter, Value value) throws IOException {
        File file = this.tempFileAllocator.allocate("stella-column-block-", ".tmp");
        timeIndexMPCFileWriter.withColumnSet(columnSet -> {
            Column column = columnSet.get(value);
            Preconditions.checkState(!column.builderIsSet(), "columnSet is already set for %s", (Object)value.toString());
            column.setBuilder(file, new NopBlockBuilder());
        });
        return MessagePack.newDefaultPacker(new GZIPOutputStream(Files.newOutputStream(file.toPath(), new OpenOption[0]), 8192));
    }

    @Override
    public void close() throws IOException {
        for (TimeIndexMPCFileWriter timeIndexMPCFileWriter : this.writers) {
            timeIndexMPCFileWriter.close();
        }
    }
}

