/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.partition.mpc.merge;

import com.treasuredata.partition.mpc.Column;
import com.treasuredata.partition.mpc.ColumnSet;
import com.treasuredata.partition.mpc.MPCFile;
import com.treasuredata.partition.mpc.merge.KeepOpenByteChannel;
import com.treasuredata.partition.mpc.merge.NopBlockBuilder;
import com.treasuredata.partition.mpc.merge.ResettableOutputStream;
import com.treasuredata.partition.mpc.writer.TempFileAllocator;
import com.treasuredata.spark.thirdparty.com.google.common.base.Preconditions;
import com.treasuredata.spark.thirdparty.com.google.common.io.ByteStreams;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.msgpack.value.ImmutableBinaryValue;
import org.msgpack.value.Value;
import org.msgpack.value.ValueFactory;

public class MergeMPCFileColumnsPacker
implements Closeable {
    private final TempFileAllocator tempFileAllocator;
    private final Map<Value, OutputStream> compressedOutputs;
    private final Map<Value, ResettableOutputStream> fileOutputs;
    private int totalPosition;

    public MergeMPCFileColumnsPacker(TempFileAllocator tempFileAllocator) {
        this.tempFileAllocator = Objects.requireNonNull(tempFileAllocator, "tempFileAllocator is null");
        this.compressedOutputs = new HashMap<Value, OutputStream>();
        this.fileOutputs = new HashMap<Value, ResettableOutputStream>();
    }

    public void extract(ColumnSet columnSet, File file, long l) throws IOException {
        Object object;
        Preconditions.checkState(file.exists() && file.canRead(), "cannot access local file: " + file.getAbsolutePath());
        Set<Value> set = this.getColumnNames(columnSet);
        Throwable object22 = null;
        try (SeekableByteChannel seekableByteChannel = Files.newByteChannel(file.toPath(), StandardOpenOption.READ);){
            object = MPCFile.readHeaderAndColumnInfo(seekableByteChannel, file.length());
            for (MPCFile.ColumnInfo columnInfo : ((MPCFile.HeaderAndColumnInfo)object).getColumnList()) {
                ImmutableBinaryValue immutableBinaryValue = ValueFactory.newBinary(columnInfo.getName());
                OutputStream outputStream = this.getColumnOutput(columnSet, immutableBinaryValue);
                if (!set.remove(immutableBinaryValue)) {
                    for (long i = 0L; i < (long)this.totalPosition; ++i) {
                        outputStream.write(-64);
                    }
                }
                seekableByteChannel.position(columnInfo.getOffset());
                try (GZIPInputStream gZIPInputStream = new GZIPInputStream(Channels.newInputStream(new KeepOpenByteChannel(seekableByteChannel, columnInfo.getSize())));){
                    ByteStreams.copy(gZIPInputStream, outputStream);
                }
                this.closeFileOutput(immutableBinaryValue);
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            throw throwable;
        }
        for (Value value : set) {
            object = this.getColumnOutput(columnSet, value);
            for (long i = 0L; i < l; ++i) {
                ((OutputStream)object).write(-64);
            }
            this.closeFileOutput(value);
        }
        this.totalPosition = (int)((long)this.totalPosition + l);
    }

    public void finish(ColumnSet columnSet) throws IOException {
        for (Column column : columnSet) {
            OutputStream outputStream = this.getColumnOutput(columnSet, column.getName());
            outputStream.close();
        }
        this.compressedOutputs.clear();
        this.fileOutputs.clear();
    }

    private Set<Value> getColumnNames(ColumnSet columnSet) {
        HashSet<Value> hashSet = new HashSet<Value>();
        for (Column column : columnSet) {
            hashSet.add(column.getName());
        }
        return hashSet;
    }

    private OutputStream getColumnOutput(ColumnSet columnSet, Value value) throws IOException {
        File file;
        Column column = columnSet.get(value);
        if (column.builderIsSet()) {
            file = column.getFile();
        } else {
            file = this.tempFileAllocator.allocate("stella-column-block-", ".tmp");
            column.setBuilder(file, new NopBlockBuilder());
        }
        OutputStream outputStream = Files.newOutputStream(file.toPath(), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        ResettableOutputStream resettableOutputStream = this.fileOutputs.get(value);
        if (resettableOutputStream == null) {
            resettableOutputStream = new ResettableOutputStream(outputStream);
            this.fileOutputs.put(value, resettableOutputStream);
            this.compressedOutputs.put(value, new GZIPOutputStream((OutputStream)resettableOutputStream, 8192));
        } else {
            resettableOutputStream.reset(outputStream);
        }
        return Objects.requireNonNull(this.compressedOutputs.get(value), String.format("compressedOutput for %s is null", value.toString()));
    }

    private void closeFileOutput(Value value) throws IOException {
        ResettableOutputStream resettableOutputStream = Objects.requireNonNull(this.fileOutputs.get(value), String.format("fileOutput for %s is null", value.toString()));
        resettableOutputStream.close();
    }

    @Override
    public void close() throws IOException {
        for (OutputStream outputStream : this.fileOutputs.values()) {
            outputStream.close();
        }
        this.compressedOutputs.clear();
        this.fileOutputs.clear();
    }
}

