/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.partition.mpc.merge;

import com.treasuredata.partition.mpc.Column;
import com.treasuredata.partition.mpc.ColumnSet;
import com.treasuredata.partition.mpc.merge.ColumnNamesComparator;
import com.treasuredata.partition.mpc.merge.MergeMPCFileColumnsPacker;
import com.treasuredata.partition.mpc.merge.TimeIndexMPCFileWriter;
import com.treasuredata.partition.mpc.writer.TempFileAllocator;
import com.treasuredata.spark.thirdparty.com.google.common.collect.ImmutableList;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Comparator;
import java.util.List;

public class MPCFileMerger
implements Closeable {
    private final TimeIndexMPCFileWriter writer;
    private final MergeMPCFileColumnsPacker columnsPacker;

    public MPCFileMerger(TempFileAllocator tempFileAllocator, List<String> list) throws IOException {
        this.writer = new TimeIndexMPCFileWriter(ImmutableList.of(), tempFileAllocator, (Comparator<Column>)new ColumnNamesComparator(list));
        this.columnsPacker = new MergeMPCFileColumnsPacker(tempFileAllocator);
    }

    public void write(File file, long l, long l2, long l3) {
        this.writer.updateIndexRange(l2);
        this.writer.updateIndexRange(l3);
        this.writer.addRecordCount(l);
        this.writer.withColumnSet(columnSet -> {
            try {
                this.columnsPacker.extract((ColumnSet)columnSet, file, l);
            }
            catch (IOException iOException) {
                throw new UncheckedIOException(iOException);
            }
        });
    }

    public TimeIndexMPCFileWriter finish() throws IOException {
        this.writer.withColumnSet(columnSet -> {
            try {
                this.columnsPacker.finish((ColumnSet)columnSet);
            }
            catch (IOException iOException) {
                throw new UncheckedIOException(iOException);
            }
        });
        this.writer.finish();
        return this.writer;
    }

    @Override
    public void close() throws IOException {
        try {
            this.columnsPacker.close();
        }
        finally {
            this.writer.close();
        }
    }
}

