/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.partition.mpc.merge;

import com.treasuredata.partition.mpc.Column;
import com.treasuredata.partition.mpc.merge.NopBlockBuilder;
import com.treasuredata.partition.mpc.merge.TimeIndexMPCFileWriter;
import com.treasuredata.partition.mpc.writer.TempFileAllocator;
import com.treasuredata.spark.thirdparty.com.google.common.base.Preconditions;
import com.treasuredata.spark.thirdparty.com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessagePacker;
import org.msgpack.value.Value;

public class ColumnsMPCFileWriter
extends TimeIndexMPCFileWriter {
    private final MessagePacker[] packers;
    private MessagePacker currentPacker;
    private int columnIndex = -1;

    public ColumnsMPCFileWriter(List<Value> list, TempFileAllocator tempFileAllocator) throws IOException {
        super(list, tempFileAllocator);
        this.packers = new MessagePacker[list.size()];
        this.withColumnSet(columnSet -> {
            try {
                Column[] columnArray = columnSet.toArray();
                for (int i = 0; i < this.packers.length; ++i) {
                    Preconditions.checkState(!columnArray[i].builderIsSet(), "builder is already set");
                    File file = tempFileAllocator.allocate("presto-column-block-", ".tmp");
                    columnArray[i].setBuilder(file, new NopBlockBuilder());
                    this.packers[i] = MessagePack.newDefaultPacker(new GZIPOutputStream(Files.newOutputStream(file.toPath(), new OpenOption[0]), 8192));
                }
            }
            catch (IOException iOException) {
                throw new UncheckedIOException(iOException);
            }
        });
    }

    @Override
    public void finish() throws IOException {
        for (int i = 0; i < this.packers.length; ++i) {
            this.packers[i].close();
            this.packers[i] = null;
        }
        super.finish();
    }

    public boolean isFinished() {
        return this.getHeader() != null;
    }

    public List<MessagePacker> getPackers() {
        if (this.isFinished()) {
            throw new IllegalStateException("Cannot access packers after finish() called");
        }
        return ImmutableList.copyOf(this.packers);
    }

    public void nextPacker() {
        ++this.columnIndex;
        this.currentPacker = this.packers[this.columnIndex % this.packers.length];
    }

    public void packValue(Value value) throws IOException {
        this.currentPacker.packValue(value);
    }

    @Override
    public void close() throws IOException {
        try {
            for (int i = 0; i < this.packers.length; ++i) {
                if (this.packers[i] == null) continue;
                this.packers[i].close();
            }
        }
        finally {
            super.close();
        }
    }
}

