/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.partition.mpc.filter.gzip;

import com.treasuredata.partition.mpc.filter.gzip.Zlib;
import java.io.IOException;
import java.nio.ByteBuffer;
import jnr.ffi.LibraryLoader;
import jnr.ffi.Pointer;
import jnr.ffi.Runtime;
import jnr.ffi.Struct;

public final class ZStream
extends Struct {
    private static Runtime runtime;
    private static Zlib zlib;
    private static Pointer zlibVersion;
    private static boolean available;
    public Struct.Pointer next_in = new Struct.Pointer(this);
    public Struct.Unsigned32 avail_in = new Struct.Unsigned32(this);
    public Struct.UnsignedLong total_in = new Struct.UnsignedLong(this);
    public Struct.Pointer next_out = new Struct.Pointer(this);
    public Struct.Unsigned32 avail_out = new Struct.Unsigned32(this);
    public Struct.UnsignedLong total_out = new Struct.UnsignedLong(this);
    public Struct.UTF8StringRef msg = new Struct.UTF8StringRef(this);
    public Struct.Pointer internal_state = new Struct.Pointer(this);
    public Struct.Pointer zalloc = new Struct.Pointer(this);
    public Struct.Pointer zfree = new Struct.Pointer(this);
    public Struct.Pointer opaque = new Struct.Pointer(this);
    public Struct.Signed32 data_type = new Struct.Signed32(this);
    public Struct.UnsignedLong adler = new Struct.UnsignedLong(this);
    public Struct.UnsignedLong reserved = new Struct.UnsignedLong(this);
    private Pointer pointer = !System.getProperty("os.name").toLowerCase().contains("mac") ? Struct.getMemory(this) : Struct.getMemory(this, 32);
    private ByteBuffer direct;
    private int size = Struct.size(this);

    static void initLibrary() {
        runtime = Runtime.getSystemRuntime();
        zlib = LibraryLoader.create(Zlib.class).load("z");
        zlibVersion = zlib.zlibVersion();
    }

    public static boolean available() {
        return available;
    }

    public static Zlib getZlib() {
        return zlib;
    }

    public static Pointer getZlibVersion() {
        return zlibVersion;
    }

    public ZStream() {
        super(runtime);
        this.internal_state.set(Pointer.wrap(runtime, 0L));
        this.zalloc.set(Pointer.wrap(runtime, 0L));
        this.zfree.set(Pointer.wrap(runtime, 0L));
        this.data_type.set(0);
        this.adler.set(0L);
        this.reserved.set(0L);
    }

    public Pointer getPointer() {
        return this.pointer;
    }

    public int getSize() {
        return this.size;
    }

    public int set_in(ByteBuffer byteBuffer, int n) {
        if (!byteBuffer.isDirect()) {
            if (this.direct == null) {
                this.direct = ByteBuffer.allocateDirect(1024);
            } else {
                this.direct.position(0);
                this.direct.limit(this.direct.capacity());
            }
            if (byteBuffer.remaining() > this.direct.limit()) {
                n = this.direct.limit();
                ByteBuffer byteBuffer2 = byteBuffer.slice();
                byteBuffer2.limit(n);
                this.direct.put(byteBuffer2);
            } else {
                int n2 = byteBuffer.position();
                this.direct.put(byteBuffer);
                byteBuffer.position(n2);
            }
            this.direct.position(0);
            byteBuffer = this.direct;
        }
        this.next_in.set(Pointer.wrap(runtime, byteBuffer));
        this.avail_in.set(n);
        return n;
    }

    public int set_out(ByteBuffer byteBuffer, int n) {
        if (!byteBuffer.isDirect()) {
            throw new IllegalArgumentException("only direct buffer is supported");
        }
        this.next_out.set(Pointer.wrap(runtime, byteBuffer));
        this.avail_out.set(n);
        return n;
    }

    public void checkError(int n) throws IOException {
        if (n != 0) {
            throw new IOException("zlib failed with code " + n + " : " + this.msg.get());
        }
    }

    static {
        available = false;
        try {
            ZStream.initLibrary();
            available = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

