/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.partition.mpc.filter;

import com.treasuredata.partition.mpc.buffer.Buffer;
import com.treasuredata.partition.mpc.filter.FilterSink;
import com.treasuredata.partition.mpc.filter.OutputFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;

public class OutputStreamFilter
implements OutputFilter {
    protected FilterSink sink;
    private SinkOutputStream sinkStream = new SinkOutputStream();
    private WritableByteChannel filteringChannel;

    private ByteBuffer getCurrentBuffer() throws IOException {
        return this.sink.getCurrentBuffer();
    }

    private ByteBuffer getNextBuffer() throws IOException {
        this.sink.forward();
        return this.sink.getCurrentBuffer();
    }

    protected OutputStream getSinkStream() {
        return this.sinkStream;
    }

    protected OutputStream createStream() throws IOException {
        return this.getSinkStream();
    }

    protected WritableByteChannel createChannel() throws IOException {
        return Channels.newChannel(this.createStream());
    }

    @Override
    public void setSink(FilterSink filterSink) {
        this.sink = filterSink;
    }

    @Override
    public void offer(Buffer buffer) throws IOException {
        if (this.filteringChannel == null) {
            this.filteringChannel = this.createChannel();
        }
        this.filteringChannel.write(buffer.getByteBuffer());
        this.sink.forward();
        buffer.release();
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        if (this.filteringChannel == null) {
            this.filteringChannel = this.createChannel();
        }
        int n = this.filteringChannel.write(byteBuffer);
        this.sink.forward();
        return n;
    }

    @Override
    public void complete() throws IOException {
        if (this.filteringChannel != null) {
            this.filteringChannel.close();
            this.filteringChannel = null;
        }
        this.sink.complete();
    }

    @Override
    public void reset() throws IOException {
        if (this.filteringChannel != null) {
            this.filteringChannel.close();
            this.filteringChannel = null;
        }
        if (this.sink != null) {
            this.sink.close();
            this.sink = null;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.filteringChannel != null) {
            this.filteringChannel.close();
            this.filteringChannel = null;
        }
        if (this.sink != null) {
            this.sink.close();
            this.sink = null;
        }
    }

    private class SinkOutputStream
    extends OutputStream {
        private SinkOutputStream() {
        }

        @Override
        public void write(int n) throws IOException {
            byte[] byArray = new byte[]{(byte)n};
            this.write(byArray);
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            this.write(byArray, 0, byArray.length);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            ByteBuffer byteBuffer = OutputStreamFilter.this.getCurrentBuffer();
            int n3 = byteBuffer.remaining();
            while (n3 < n2) {
                byteBuffer.put(byArray, n, n3);
                n2 -= n3;
                n += n3;
                byteBuffer = OutputStreamFilter.this.getNextBuffer();
                n3 = byteBuffer.remaining();
            }
            byteBuffer.put(byArray, n, n2);
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }
    }
}

