/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.partition.mpc.filter;

import com.treasuredata.partition.mpc.buffer.Buffer;
import com.treasuredata.partition.mpc.buffer.BufferUtil;
import com.treasuredata.partition.mpc.buffer.IoBufferAllocator;
import com.treasuredata.partition.mpc.filter.FilterSource;
import com.treasuredata.partition.mpc.filter.InputFilter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;

public class InputStreamFilter
implements InputFilter,
FilterSource {
    private FilterSource source;
    private IoBufferAllocator bufferAllocator;
    private InputStream sourceStream;
    private ReadableByteChannel filteringChannel;

    public InputStreamFilter(IoBufferAllocator ioBufferAllocator) throws IOException {
        this.bufferAllocator = ioBufferAllocator;
        this.sourceStream = new SourceInputStream();
    }

    protected InputStream getSourceStream() {
        return this.sourceStream;
    }

    protected InputStream createStream() throws IOException {
        return this.getSourceStream();
    }

    @Override
    public void setSource(FilterSource filterSource) {
        this.source = filterSource;
    }

    protected ReadableByteChannel createChannel() throws IOException {
        return Channels.newChannel(this.createStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Buffer next() throws IOException {
        Buffer buffer = this.bufferAllocator.allocateIoBuffer();
        try {
            ByteBuffer byteBuffer = buffer.getByteBuffer();
            int n = byteBuffer.position();
            do {
                if (this.filteringChannel == null) {
                    this.filteringChannel = this.createChannel();
                }
                if (this.filteringChannel.read(byteBuffer) >= 0) continue;
                Buffer buffer2 = null;
                return buffer2;
            } while (byteBuffer.position() == n);
            byteBuffer.limit(byteBuffer.position());
            byteBuffer.position(n);
            Buffer buffer3 = buffer;
            buffer = null;
            Buffer buffer4 = buffer3;
            return buffer4;
        }
        finally {
            if (buffer != null) {
                buffer.release();
            }
        }
    }

    @Override
    public void reset() throws IOException {
        if (this.filteringChannel != null) {
            this.filteringChannel.close();
            this.filteringChannel = null;
        }
        if (this.source != null) {
            this.source.close();
            this.source = null;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.filteringChannel != null) {
            this.filteringChannel.close();
            this.filteringChannel = null;
        }
        if (this.source != null) {
            this.source.close();
            this.source = null;
        }
    }

    private class SourceInputStream
    extends InputStream {
        private Buffer buffer;
        private byte[] b1;
        private byte[] array = null;
        private ByteBuffer bb = null;

        private SourceInputStream() {
        }

        @Override
        public int read() throws IOException {
            int n;
            if (this.b1 == null) {
                this.b1 = new byte[1];
            }
            if ((n = this.read(this.b1)) == 1) {
                return this.b1[0] & 0xFF;
            }
            return -1;
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3;
            ByteBuffer byteBuffer = this.array == byArray ? this.bb : ByteBuffer.wrap(byArray);
            byteBuffer.limit(Math.min(n + n2, byteBuffer.capacity()));
            byteBuffer.position(n);
            this.bb = byteBuffer;
            this.array = byArray;
            while ((n3 = this.read(byteBuffer)) == 0) {
            }
            return n3;
        }

        private int read(ByteBuffer byteBuffer) throws IOException {
            if (this.buffer == null) {
                this.buffer = InputStreamFilter.this.source.next();
                if (this.buffer == null) {
                    return -1;
                }
            }
            ByteBuffer byteBuffer2 = this.buffer.getByteBuffer();
            int n = BufferUtil.transferByteBuffer(byteBuffer2, byteBuffer);
            if (!byteBuffer2.hasRemaining()) {
                this.buffer.release();
                this.buffer = null;
            }
            return n;
        }

        @Override
        public void close() throws IOException {
            if (this.buffer != null) {
                this.buffer.release();
                this.buffer = null;
            }
        }
    }
}

