/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.partition.mpc.buffer;

import com.treasuredata.partition.mpc.buffer.Buffer;
import com.treasuredata.partition.mpc.buffer.BufferAllocator;
import com.treasuredata.partition.mpc.buffer.BufferUtil;
import com.treasuredata.partition.mpc.buffer.FileBufferException;
import com.treasuredata.partition.mpc.writer.TempFileAllocator;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

public class FileBufferAllocator
implements BufferAllocator {
    private TempFileAllocator tempFileAllocator;
    private String prefix;
    private String suffix;
    static final Object mmapMutex = new Object();

    public FileBufferAllocator(File file, String string, String string2) throws IOException {
        this(new File[]{file}, string, string2);
    }

    public FileBufferAllocator(File[] fileArray, String string, String string2) throws IOException {
        this.tempFileAllocator = new TempFileAllocator(fileArray);
        this.prefix = string;
        this.suffix = string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Buffer allocate(int n) {
        try {
            File file = this.tempFileAllocator.allocate(this.prefix, this.suffix);
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            try {
                MappedByteBuffer mappedByteBuffer;
                FileChannel fileChannel = randomAccessFile.getChannel();
                randomAccessFile.setLength(n);
                Object object = mmapMutex;
                synchronized (object) {
                    mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, n);
                }
                object = new FileBuffer(mappedByteBuffer);
                return object;
            }
            catch (IOException iOException) {
                throw new FileBufferException(String.format("Creating mmap on file '%s' failed", file.getPath()), iOException);
            }
            finally {
                randomAccessFile.close();
                file.delete();
            }
        }
        catch (IOException iOException) {
            throw new FileBufferException(String.format("Buffer file allocation from directory '%s' failed", this.prefix), iOException);
        }
    }

    private void release(FileBuffer fileBuffer) {
        BufferUtil.releaseDirectBuffer(fileBuffer.bb);
    }

    @Override
    public void close() {
    }

    class FileBuffer
    implements Buffer {
        ByteBuffer bb;

        public FileBuffer(ByteBuffer byteBuffer) {
            this.bb = byteBuffer;
        }

        @Override
        public ByteBuffer getByteBuffer() {
            return this.bb;
        }

        @Override
        public void release() {
            FileBufferAllocator.this.release(this);
        }
    }
}

