/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.partition.mpc.buffer;

import com.treasuredata.partition.mpc.buffer.Buffer;
import com.treasuredata.partition.mpc.buffer.BufferAllocator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;

public class CachedBufferAllocator
implements BufferAllocator {
    private static final int BASE_SHIFT = 10;
    private static final int MAX_SHIFT = 20;
    protected BufferAllocator parentAllocator;
    private long maxCacheSize;
    private AtomicLong allocatedSize;
    private ConcurrentLinkedQueue<CachedBuffer>[] base;

    public CachedBufferAllocator(BufferAllocator bufferAllocator, long l) {
        this.parentAllocator = bufferAllocator;
        this.maxCacheSize = l;
        this.allocatedSize = new AtomicLong(0L);
        this.base = new ConcurrentLinkedQueue[10];
    }

    @Override
    public Buffer allocate(int n) {
        int n2 = 31 - Integer.numberOfLeadingZeros(n);
        int n3 = 1 << n2;
        if (n < n3) {
            n3 = 1 << ++n2;
        }
        if (n2 < 10) {
            n2 = 10;
            n3 = 1024;
        } else if (n2 >= 20) {
            throw new OutOfMemoryError("CachedBufferAllocator can't allocate memory larger than 1048575 bytes but trying to allocate " + n + " bytes");
        }
        ConcurrentLinkedQueue<CachedBuffer> concurrentLinkedQueue = this.getQueue(n2);
        CachedBuffer cachedBuffer = concurrentLinkedQueue.poll();
        if (cachedBuffer == null) {
            cachedBuffer = this.allocateNewBuffer(n3);
        }
        return cachedBuffer;
    }

    private CachedBuffer allocateNewBuffer(int n) {
        this.allocatedSize.addAndGet(n);
        return new CachedBuffer(this.parentAllocator.allocate(n), n);
    }

    private void release(CachedBuffer cachedBuffer) {
        if (this.allocatedSize.get() > this.maxCacheSize) {
            cachedBuffer.buffer.release();
            this.allocatedSize.addAndGet(-cachedBuffer.getSize());
            return;
        }
        ByteBuffer byteBuffer = cachedBuffer.getByteBuffer();
        byteBuffer.position(0);
        byteBuffer.limit(byteBuffer.capacity());
        int n = 31 - Integer.numberOfLeadingZeros(cachedBuffer.allocSize);
        ConcurrentLinkedQueue<CachedBuffer> concurrentLinkedQueue = this.getQueue(n);
        concurrentLinkedQueue.offer(cachedBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        ConcurrentLinkedQueue<CachedBuffer>[] concurrentLinkedQueueArray = this.base;
        synchronized (this.base) {
            for (ConcurrentLinkedQueue<CachedBuffer> concurrentLinkedQueue : this.base) {
                CachedBuffer cachedBuffer;
                if (concurrentLinkedQueue == null) continue;
                while ((cachedBuffer = concurrentLinkedQueue.poll()) != null) {
                    cachedBuffer.buffer.release();
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.parentAllocator.close();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ConcurrentLinkedQueue<CachedBuffer> getQueue(int n) {
        int n2 = n - 10;
        ConcurrentLinkedQueue<CachedBuffer> concurrentLinkedQueue = this.base[n2];
        if (concurrentLinkedQueue != null) return concurrentLinkedQueue;
        ConcurrentLinkedQueue<CachedBuffer>[] concurrentLinkedQueueArray = this.base;
        synchronized (this.base) {
            concurrentLinkedQueue = this.base[n2];
            if (concurrentLinkedQueue != null) return concurrentLinkedQueue;
            this.base[n2] = new ConcurrentLinkedQueue();
            return this.base[n2];
        }
    }

    private class CachedBuffer
    implements Buffer {
        private Buffer buffer;
        private int allocSize;

        public CachedBuffer(Buffer buffer, int n) {
            this.buffer = buffer;
            this.allocSize = n;
        }

        @Override
        public ByteBuffer getByteBuffer() {
            return this.buffer.getByteBuffer();
        }

        public int getSize() {
            return this.allocSize;
        }

        @Override
        public void release() {
            CachedBufferAllocator.this.release(this);
        }
    }
}

