/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.partition.io.impl;

import com.treasuredata.partition.io.IOConfig;
import com.treasuredata.partition.io.IOManager;
import com.treasuredata.partition.io.IORequest;
import com.treasuredata.partition.io.IOServiceType;
import com.treasuredata.partition.io.impl.jetty.JettyRequestHandler;
import com.treasuredata.partition.io.impl.jetty.JettyResponseHandler;
import com.treasuredata.partition.io.impl.jetty.ManagedHttpClient;
import com.treasuredata.spark.thirdparty.com.google.common.base.Preconditions;
import com.treasuredata.spark.thirdparty.com.google.common.base.Strings;
import com.treasuredata.spark.thirdparty.com.google.common.base.Throwables;
import com.treasuredata.spark.thirdparty.com.google.common.net.HostAndPort;
import java.io.EOFException;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.UnresolvedAddressException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import javax.net.ssl.SSLException;
import org.eclipse.jetty.client.AbstractConnectionPool;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.HttpResponseException;
import org.eclipse.jetty.client.Socks4Proxy;
import org.eclipse.jetty.client.api.Destination;
import org.eclipse.jetty.client.http.HttpDestinationOverHTTP;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.util.HttpCookieStore;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;

public class JettyIOManager
extends IOManager {
    private static final Logger log = Logger.getLogger(JettyIOManager.class.getName());
    private final HttpClient httpClient;
    private static final int MAX_RETRIES_PER_FILE = 10;
    private static final int MAX_RETRIES_ON_NOT_FOUND = 3;
    private static final int MAX_RETRIES_ON_SLOW_DOWN = 20;
    private static final String CODE_SLOW_DOWN = "<Code>SlowDown</Code>";

    public JettyIOManager(String string, IOConfig iOConfig) {
        super(string, iOConfig);
        Preconditions.checkArgument(iOConfig.getServiceType() == IOServiceType.HTTP, "Invalid %s configuration", (Object)string);
        this.httpClient = this.createHttpClient();
    }

    @Override
    public void start() {
        super.start();
        try {
            this.httpClient.start();
        }
        catch (Exception exception) {
            throw Throwables.propagate(exception);
        }
        this.httpClient.getContentDecoderFactories().clear();
    }

    @Override
    public void shutdown() {
        super.shutdown();
        try {
            this.httpClient.stop();
        }
        catch (Exception exception) {
            throw Throwables.propagate(exception);
        }
    }

    @Override
    public int getActiveRequestCount() {
        int n = 0;
        for (Destination destination : this.httpClient.getDestinations()) {
            n += ((AbstractConnectionPool)((HttpDestinationOverHTTP)destination).getConnectionPool()).getConnectionCount();
            n += ((HttpDestinationOverHTTP)destination).getHttpExchanges().size();
        }
        return n;
    }

    private HttpClient createHttpClient() {
        IOConfig iOConfig = this.getConfig();
        SslContextFactory sslContextFactory = new SslContextFactory();
        sslContextFactory.setEndpointIdentificationAlgorithm("HTTPS");
        if (iOConfig.getKeyStorePath() != null) {
            sslContextFactory.setKeyStorePath(iOConfig.getKeyStorePath());
            sslContextFactory.setKeyStorePassword(iOConfig.getKeyStorePassword());
        }
        ManagedHttpClient managedHttpClient = new ManagedHttpClient(this.getBufferPool(), sslContextFactory, iOConfig.getReceiveSocketBufferSize());
        managedHttpClient.setCookieStore(new HttpCookieStore.Empty());
        managedHttpClient.setIdleTimeout(iOConfig.getIdleTimeout());
        managedHttpClient.setConnectTimeout(iOConfig.getConnectTimeout());
        managedHttpClient.setAddressResolutionTimeout(iOConfig.getConnectTimeout());
        HostAndPort hostAndPort = iOConfig.getSocksProxy();
        if (hostAndPort != null) {
            managedHttpClient.getProxyConfiguration().getProxies().add(new Socks4Proxy(hostAndPort.getHost(), hostAndPort.getPortOrDefault(1080)));
        }
        managedHttpClient.setExecutor(this.getExecutor());
        managedHttpClient.setMaxConnectionsPerDestination(iOConfig.getMaxConnectionsPerServer());
        managedHttpClient.setResponseBufferSize(iOConfig.getBufferSize());
        managedHttpClient.setMaxRequestsQueuedPerDestination(iOConfig.getMaxConnectionsPerServer() * 1000);
        managedHttpClient.setTCPNoDelay(true);
        managedHttpClient.setDispatchIO(true);
        managedHttpClient.setStrictEventOrdering(true);
        return managedHttpClient;
    }

    @Override
    protected void startRequest(IORequest iORequest) {
        IORequest iORequest2 = iORequest.applyFilters();
        HttpRequest httpRequest = (HttpRequest)this.httpClient.newRequest(iORequest2.getUri());
        httpRequest.getHeaders().remove(HttpHeader.USER_AGENT);
        httpRequest.method(iORequest2.getMethod());
        httpRequest.header(HttpHeader.CONNECTION, "Keep-Alive");
        for (Map.Entry<String, String> entry : iORequest2.getHeaders().entries()) {
            httpRequest.header(entry.getKey(), entry.getValue());
        }
        iORequest2.getAttributes().forEach((string, object) -> httpRequest.attribute((String)string, object));
        httpRequest.listener(new JettyRequestHandler(iORequest)).timeout(this.getConfig().getRequestTimeout(), TimeUnit.MILLISECONDS).send(new JettyResponseHandler(this, iORequest));
    }

    private Executor getExecutor() {
        IOConfig iOConfig = this.getConfig();
        QueuedThreadPool queuedThreadPool = new QueuedThreadPool(iOConfig.getMaxThreads(), iOConfig.getMinThreads());
        return queuedThreadPool;
    }

    @Override
    protected boolean needRetry(IORequest iORequest, Throwable throwable) {
        Objects.requireNonNull(throwable);
        if (throwable instanceof TimeoutException || throwable instanceof EOFException || throwable instanceof SocketTimeoutException || throwable instanceof ClosedChannelException || throwable instanceof UnresolvedAddressException || throwable instanceof NoRouteToHostException || throwable instanceof UnknownHostException || throwable instanceof SSLException || throwable instanceof SocketException && throwable.getMessage().indexOf("Connection reset by peer") >= 0) {
            return true;
        }
        if (throwable instanceof HttpResponseException) {
            HttpResponseException httpResponseException = (HttpResponseException)throwable;
            int n = httpResponseException.getResponse().getStatus();
            log.fine(String.format("HttpResponseError %d : %s", n, httpResponseException.getMessage()));
            if (n == 0 || n == 400 || n == 403 || n == 404 || n >= 500) {
                if (n != 404) {
                    iORequest.getHandler().report(iORequest, "HttpResponseError " + n, "status", String.format("%d %s", n, httpResponseException.getResponse().getReason()), "trace", Strings.nullToEmpty(httpResponseException.getMessage()));
                }
                return true;
            }
        }
        return false;
    }

    @Override
    protected int getMaxRetry(IORequest iORequest, Throwable throwable) {
        Objects.requireNonNull(throwable);
        if (throwable instanceof HttpResponseException) {
            HttpResponseException httpResponseException = (HttpResponseException)throwable;
            int n = httpResponseException.getResponse().getStatus();
            if (n == 404) {
                return 3;
            }
            if (this.isSlowDown(iORequest, throwable)) {
                return 20;
            }
        }
        return 10;
    }

    @Override
    protected boolean isRequestSkippable(IORequest iORequest, Throwable throwable) {
        HttpResponseException httpResponseException;
        int n;
        if (!iORequest.getHandler().isSkippable()) {
            return false;
        }
        Objects.requireNonNull(throwable);
        return throwable instanceof HttpResponseException && (n = (httpResponseException = (HttpResponseException)throwable).getResponse().getStatus()) == 404;
    }

    @Override
    protected boolean isSlowDown(IORequest iORequest, Throwable throwable) {
        HttpResponseException httpResponseException;
        int n;
        Objects.requireNonNull(throwable);
        return throwable instanceof HttpResponseException && (n = (httpResponseException = (HttpResponseException)throwable).getResponse().getStatus()) == 503 && httpResponseException.getMessage() != null && httpResponseException.getMessage().contains(CODE_SLOW_DOWN);
    }
}

