/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.partition.io.impl;

import alluxio.AlluxioURI;
import alluxio.client.file.FileSystem;
import alluxio.exception.AlluxioException;
import alluxio.exception.FileDoesNotExistException;
import com.treasuredata.partition.io.IOConfig;
import com.treasuredata.partition.io.IOManager;
import com.treasuredata.partition.io.IORequest;
import com.treasuredata.partition.io.IOServiceType;
import com.treasuredata.partition.io.impl.alluxio.AlluxioResponseHandler;
import com.treasuredata.spark.thirdparty.com.google.common.base.Preconditions;
import com.treasuredata.spark.thirdparty.com.google.common.collect.ImmutableMap;
import java.io.EOFException;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.UnresolvedAddressException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import javax.net.ssl.SSLException;

public class AlluxioIOManager
extends IOManager {
    private static final Logger log = Logger.getLogger(AlluxioIOManager.class.getName());
    private final FileSystem fileSystem;
    private final Map<String, String> pathMap;
    private final ExecutorService executor;
    private static final int MAX_RETRIES_PER_FILE = 10;
    private static final int MAX_RETRIES_ON_NOT_FOUND = 3;
    private static final int MAX_RETRIES_ON_SLOW_DOWN = 20;

    public AlluxioIOManager(String string, IOConfig iOConfig) {
        super(string, iOConfig);
        Preconditions.checkArgument(iOConfig.getServiceType() == IOServiceType.ALLUXIO, "Invalid %s configuration", (Object)string);
        this.fileSystem = FileSystem.Factory.get();
        this.pathMap = ImmutableMap.copyOf(iOConfig.getPathMap());
        this.executor = Executors.newCachedThreadPool();
    }

    @Override
    public void start() {
        super.start();
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }

    @Override
    public int getActiveRequestCount() {
        return 0;
    }

    @Override
    protected void startRequest(IORequest iORequest) {
        IORequest iORequest2 = iORequest.applyFilters();
        Path path = Paths.get(iORequest2.getUri().getPath(), new String[0]);
        String string = path.getName(0).toString();
        String string2 = path.subpath(1, path.getNameCount()).toString();
        Path path2 = Paths.get(Objects.requireNonNull(this.pathMap.get(string), "No mount point for bucket: " + string), string2);
        AlluxioURI alluxioURI = new AlluxioURI(path2.toString());
        this.executor.submit(new AlluxioResponseHandler(this, iORequest, this.fileSystem, alluxioURI));
    }

    @Override
    protected boolean needRetry(IORequest iORequest, Throwable throwable) {
        Objects.requireNonNull(throwable);
        if (throwable instanceof TimeoutException || throwable instanceof EOFException || throwable instanceof SocketTimeoutException || throwable instanceof ClosedChannelException || throwable instanceof UnresolvedAddressException || throwable instanceof NoRouteToHostException || throwable instanceof UnknownHostException || throwable instanceof SSLException || throwable instanceof SocketException && throwable.getMessage().indexOf("Connection reset by peer") >= 0) {
            return true;
        }
        return throwable instanceof FileDoesNotExistException;
    }

    @Override
    protected int getMaxRetry(IORequest iORequest, Throwable throwable) {
        Objects.requireNonNull(throwable);
        if (throwable instanceof FileDoesNotExistException) {
            return 3;
        }
        return 10;
    }

    @Override
    protected boolean isRequestSkippable(IORequest iORequest, Throwable throwable) {
        if (!iORequest.getHandler().isSkippable()) {
            return false;
        }
        Objects.requireNonNull(throwable);
        return throwable instanceof FileDoesNotExistException;
    }

    @Override
    protected boolean isSlowDown(IORequest iORequest, Throwable throwable) {
        Objects.requireNonNull(throwable);
        if (throwable instanceof AlluxioException) {
            // empty if block
        }
        return false;
    }
}

