/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.partition.io.buffer;

import com.treasuredata.partition.io.buffer.FastBlockingQueue;
import com.treasuredata.partition.io.buffer.IOBuffer;
import com.treasuredata.partition.io.buffer.IOBufferListener;
import com.treasuredata.spark.thirdparty.com.google.common.base.Throwables;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import sun.nio.ch.DirectBuffer;

public class IOBufferPool {
    private static final Logger log = Logger.getLogger(IOBufferPool.class.getSimpleName());
    private final int bufferSize;
    private final AtomicInteger availableCapacity;
    private final FastBlockingQueue<ByteBuffer> directBuffers;

    public IOBufferPool(int n, long l) {
        this.bufferSize = n;
        int n2 = (int)(l / (long)n);
        this.availableCapacity = new AtomicInteger(n2);
        this.directBuffers = new FastBlockingQueue(n2);
    }

    public final int getBufferSize() {
        return this.bufferSize;
    }

    public IOBuffer allocate(IOBufferListener iOBufferListener) {
        ByteBuffer byteBuffer = this.directBuffers.poll();
        if (byteBuffer == null) {
            int n = this.availableCapacity.get();
            if (n <= 0) {
                try {
                    byteBuffer = this.directBuffers.poll(1000 - n / 10, TimeUnit.MILLISECONDS);
                    if (byteBuffer == null && n < 0 && n % 1000 == 0) {
                        log.warning(String.format("No available Storage Buffer (%d)...", -n));
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw Throwables.propagate(interruptedException);
                }
            }
            if (byteBuffer == null) {
                this.availableCapacity.decrementAndGet();
                byteBuffer = ByteBuffer.allocateDirect(this.bufferSize);
            }
        }
        byteBuffer.position(0);
        byteBuffer.limit(byteBuffer.capacity());
        iOBufferListener.bufferAllocated();
        return new IOBuffer(this, iOBufferListener, byteBuffer);
    }

    public void release(IOBuffer iOBuffer) {
        IOBufferListener iOBufferListener = iOBuffer.getListener();
        ByteBuffer byteBuffer = iOBuffer.getByteBuffer();
        if (!(byteBuffer instanceof DirectBuffer)) {
            return;
        }
        ByteBuffer byteBuffer2 = this.getRootBuffer(byteBuffer);
        if (!this.directBuffers.offer(byteBuffer2)) {
            this.availableCapacity.incrementAndGet();
            try {
                ((DirectBuffer)((Object)byteBuffer2)).cleaner().clean();
            }
            catch (Exception exception) {
                log.severe(exception.toString());
            }
        }
        iOBufferListener.bufferReleased();
    }

    private ByteBuffer getRootBuffer(ByteBuffer byteBuffer) {
        DirectBuffer directBuffer = (DirectBuffer)((Object)byteBuffer);
        while (directBuffer.attachment() != null) {
            directBuffer = (DirectBuffer)directBuffer.attachment();
        }
        return (ByteBuffer)((Object)directBuffer);
    }

    public int getCapacity() {
        return this.directBuffers.capacity();
    }

    public long getAvailableCapacity() {
        return this.availableCapacity.get();
    }

    public long getQueueSize() {
        return this.directBuffers.size();
    }
}

