/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.partition.io.auth;

import com.treasuredata.partition.io.IORequest;
import com.treasuredata.partition.io.IORequestFilter;
import com.treasuredata.spark.thirdparty.com.google.common.base.Preconditions;
import com.treasuredata.spark.thirdparty.com.google.common.base.Strings;
import com.treasuredata.spark.thirdparty.com.google.common.base.Throwables;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class AwsAuthentication
implements IORequestFilter {
    private static final String HMAC_SHA1 = "HmacSHA1";
    private static final char NEWLINE = '\n';
    private final String accessKey;
    private final String secretKey;

    public AwsAuthentication(String string, String string2) {
        this.accessKey = Preconditions.checkNotNull(Strings.emptyToNull(string), "access Key is null");
        this.secretKey = Preconditions.checkNotNull(Strings.emptyToNull(string2), "secret Key is null");
    }

    @Override
    public IORequest filter(IORequest iORequest) {
        String string;
        String string2 = iORequest.getHeader("Date");
        if (string2 == null) {
            string = new DateTime(DateTimeZone.UTC);
            iORequest = iORequest.addHeader("Date", string.toString("E, dd MMM YYYY HH:mm:ss z"));
        }
        string = this.canonicalize(iORequest);
        SecretKeySpec secretKeySpec = new SecretKeySpec(this.secretKey.getBytes(), HMAC_SHA1);
        Mac mac = null;
        try {
            mac = Mac.getInstance(HMAC_SHA1);
            mac.init(secretKeySpec);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException generalSecurityException) {
            throw Throwables.propagate(generalSecurityException);
        }
        byte[] byArray = mac.doFinal(string.getBytes());
        String string3 = String.format("AWS %s:%s", this.accessKey, Base64.getEncoder().encodeToString(byArray));
        iORequest = iORequest.addHeader("Authorization", string3);
        return iORequest;
    }

    private String canonicalize(IORequest iORequest) {
        StringBuilder stringBuilder = new StringBuilder(256);
        String string = iORequest.getHeader("Content-MD5");
        String string2 = iORequest.getHeader("Content-Type");
        String string3 = iORequest.getHeader("Date");
        stringBuilder.append(iORequest.getMethod()).append('\n').append(string == null ? "" : string).append('\n').append(string2 == null ? "" : string2).append('\n').append(string3).append('\n').append(iORequest.getUri().getPath());
        return stringBuilder.toString();
    }
}

