/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.partition.io;

import com.treasuredata.partition.io.IOServiceType;
import com.treasuredata.spark.thirdparty.com.google.common.base.Preconditions;
import com.treasuredata.spark.thirdparty.com.google.common.collect.ImmutableMap;
import com.treasuredata.spark.thirdparty.com.google.common.net.HostAndPort;
import com.treasuredata.spark.thirdparty.com.google.common.primitives.Ints;
import java.util.Map;

public class IOConfig {
    private final IOServiceType serviceType;
    private final int maxConnectionsPerServer;
    private final int bufferSize;
    private final long groupBufferSize;
    private final long groupDownloadSize;
    private final long systemDownloadSize;
    private final long bufferPoolSize;
    private final long receiveSocketBufferSize;
    private final long connectTimeout;
    private final long idleTimeout;
    private final String keyStorePath;
    private final String keyStorePassword;
    private final HostAndPort socksProxy;
    private final int maxThreads;
    private final int minThreads;
    private final long requestTimeout;
    private final ImmutableMap<String, String> pathMap;

    private IOConfig(IOServiceType iOServiceType, int n, int n2, long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8, int n3, int n4, String string, String string2, HostAndPort hostAndPort, Map<String, String> map) {
        this.serviceType = iOServiceType;
        this.maxConnectionsPerServer = n;
        this.bufferSize = n2;
        this.groupBufferSize = l;
        this.groupDownloadSize = l2;
        this.systemDownloadSize = l3;
        this.bufferPoolSize = l4;
        this.receiveSocketBufferSize = l5;
        this.connectTimeout = l6;
        this.idleTimeout = l7;
        this.requestTimeout = l8;
        this.maxThreads = n3;
        this.minThreads = n4;
        this.keyStorePath = string;
        this.keyStorePassword = string2;
        this.socksProxy = hostAndPort;
        this.pathMap = ImmutableMap.copyOf(map);
    }

    public static Builder builder() {
        return new Builder();
    }

    public IOServiceType getServiceType() {
        return this.serviceType;
    }

    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public long getReceiveSocketBufferSize() {
        return this.receiveSocketBufferSize;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public long getGroupBufferSize() {
        return this.groupBufferSize;
    }

    public long getGroupDownloadSize() {
        return this.groupDownloadSize;
    }

    public long getSystemDownloadSize() {
        return this.systemDownloadSize;
    }

    public long getBufferPoolSize() {
        return this.bufferPoolSize;
    }

    public int getMaxConnectionsPerServer() {
        return this.maxConnectionsPerServer;
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public long getRequestTimeout() {
        return this.requestTimeout;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public int getMinThreads() {
        return this.minThreads;
    }

    public HostAndPort getSocksProxy() {
        return this.socksProxy;
    }

    public Map<String, String> getPathMap() {
        return this.pathMap;
    }

    public static class Builder {
        private IOServiceType serviceType;
        private int maxConnectionsPerServer = 10;
        private int bufferSize = 131072;
        private long groupBufferSize = 0x4000000L;
        private long groupDownloadSize = 0x40000000L;
        private long systemDownloadSize = 0x780000000L;
        private long bufferPoolSize = 0x40000000L;
        private long receiveSocketBufferSize = 0x100000L;
        private long connectTimeout = 5000L;
        private long idleTimeout = 10000L;
        private long requestTimeout = 300000L;
        private int maxThreads = 200;
        private int minThreads = 10;
        private String keyStorePath;
        private String keyStorePassword;
        private HostAndPort socksProxy;
        private ImmutableMap.Builder<String, String> pathMap = ImmutableMap.builder();

        public Builder about(IOServiceType iOServiceType) {
            this.serviceType = iOServiceType;
            return this;
        }

        public Builder http() {
            return this.about(IOServiceType.HTTP);
        }

        public Builder maxConnectionsPerServer(int n) {
            this.maxConnectionsPerServer = n;
            return this;
        }

        public Builder receiveSocketBufferSize(long l) {
            this.receiveSocketBufferSize = l;
            return this;
        }

        public Builder bufferSize(int n) {
            this.bufferSize = n;
            return this;
        }

        public Builder bufferSize(long l) {
            this.bufferSize = Ints.checkedCast(l);
            return this;
        }

        public Builder groupBufferSize(long l) {
            this.groupBufferSize = l;
            return this;
        }

        public Builder groupDownloadSize(long l) {
            this.groupDownloadSize = l;
            return this;
        }

        public Builder systemDownloadSize(long l) {
            this.systemDownloadSize = l;
            return this;
        }

        public Builder bufferPoolSize(long l) {
            this.bufferPoolSize = l;
            return this;
        }

        public Builder connectTimeout(long l) {
            this.connectTimeout = l;
            return this;
        }

        public Builder idleTimeout(long l) {
            this.idleTimeout = l;
            return this;
        }

        public Builder requestTimeout(long l) {
            this.requestTimeout = l;
            return this;
        }

        public Builder maxThreads(int n) {
            this.maxThreads = n;
            return this;
        }

        public Builder minThreads(int n) {
            this.minThreads = n;
            return this;
        }

        public Builder keyStorePath(String string) {
            this.keyStorePath = string;
            return this;
        }

        public Builder keyStorePassword(String string) {
            this.keyStorePassword = string;
            return this;
        }

        public Builder socksProxy(HostAndPort hostAndPort) {
            this.socksProxy = hostAndPort;
            return this;
        }

        public Builder addPathMap(String string, String string2) {
            this.pathMap.put(string, string2);
            return this;
        }

        public Builder addPathMap(Map<String, String> map) {
            this.pathMap.putAll(map);
            return this;
        }

        public IOConfig build() {
            Preconditions.checkState(this.serviceType != null, "serviceType has not been set");
            Preconditions.checkState(this.bufferSize >= 1024, "bufferSize too small. bufferSize: %d", this.bufferSize);
            Preconditions.checkState(this.groupBufferSize > (long)this.bufferSize, "group buffer size too small. bufferSize: %d, groupBufferSize: %d", this.bufferSize, this.groupBufferSize);
            return new IOConfig(this.serviceType, this.maxConnectionsPerServer, this.bufferSize, this.groupBufferSize, this.groupDownloadSize, this.systemDownloadSize, this.bufferPoolSize, this.receiveSocketBufferSize, this.connectTimeout, this.idleTimeout, this.requestTimeout, this.maxThreads, this.minThreads, this.keyStorePath, this.keyStorePassword, this.socksProxy, this.pathMap.build());
        }
    }
}

