/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.RuntimeJsonMappingException;
import com.treasuredata.client.model.TDColumnType;
import com.treasuredata.spark.thirdparty.com.google.common.base.Objects;
import com.treasuredata.spark.thirdparty.com.google.common.base.Preconditions;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.json.simple.JSONArray;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.LoggerFactory;

public class TDColumn
implements Serializable {
    static final byte[] LOG_TABLE_PUSHDOWN_KEY = "time".getBytes(StandardCharsets.UTF_8);
    private final String name;
    private final TDColumnType type;
    private final byte[] key;

    public TDColumn(String name, TDColumnType type) {
        this(name, type, name.getBytes(StandardCharsets.UTF_8));
    }

    @JsonCreator
    public TDColumn(@JsonProperty(value="name") String name, @JsonProperty(value="type") String type, @JsonProperty(value="key") String key) {
        this(name, TDColumnType.parseColumnType(type), key.getBytes(StandardCharsets.UTF_8));
    }

    public TDColumn(String name, TDColumnType type, byte[] key) {
        this.name = Preconditions.checkNotNull(name, "name is null");
        this.type = Preconditions.checkNotNull(type, "type is null");
        this.key = Arrays.copyOf(Preconditions.checkNotNull(key, "key is null"), key.length);
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public TDColumnType getType() {
        return this.type;
    }

    @JsonIgnore
    public byte[] getKey() {
        return Arrays.copyOf(this.key, this.key.length);
    }

    @JsonProperty(value="key")
    public String getKeyString() {
        return new String(this.key, StandardCharsets.UTF_8);
    }

    private static JSONArray castToArray(Object obj) {
        if (obj instanceof JSONArray) {
            return (JSONArray)obj;
        }
        throw new RuntimeJsonMappingException("Not an json array: " + obj);
    }

    public static List<TDColumn> parseTuple(String jsonStr) {
        try {
            String unescaped = jsonStr.replaceAll("\\\"", "\"");
            JSONArray arr = TDColumn.castToArray(new JSONParser().parse(unescaped));
            ArrayList<TDColumn> columnList = new ArrayList<TDColumn>(arr.size());
            for (Object e : arr) {
                JSONArray columnNameAndType = TDColumn.castToArray(e);
                String[] s2 = new String[columnNameAndType.size()];
                for (int i = 0; i < columnNameAndType.size(); ++i) {
                    s2[i] = columnNameAndType.get(i).toString();
                }
                columnList.add(TDColumn.parseTuple(s2));
            }
            return columnList;
        }
        catch (ParseException e) {
            LoggerFactory.getLogger(TDColumn.class).error("Failed to parse json string", e);
            return new ArrayList<TDColumn>(0);
        }
    }

    public static TDColumn parseTuple(String[] tuple) {
        if (tuple != null) {
            if (tuple.length == 2) {
                return new TDColumn(tuple[0], TDColumnType.parseColumnType(tuple[1]), tuple[0].getBytes(StandardCharsets.UTF_8));
            }
            if (tuple.length == 3) {
                return new TDColumn(tuple[2], TDColumnType.parseColumnType(tuple[1]), tuple[0].getBytes(StandardCharsets.UTF_8));
            }
        }
        throw new RuntimeJsonMappingException("Unexpected string tuple to deserialize TDColumn");
    }

    @JsonIgnore
    public boolean isPartitionKey() {
        return Arrays.equals(LOG_TABLE_PUSHDOWN_KEY, this.getKey());
    }

    @JsonIgnore
    public String[] getTuple() {
        return new String[]{this.getKeyString(), this.type.toString(), this.name};
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TDColumn other = (TDColumn)obj;
        return Objects.equal(this.name, other.name) && Objects.equal(this.type, other.type) && Arrays.equals(this.key, other.key);
    }

    public int hashCode() {
        return Objects.hashCode(this.name, this.type, Arrays.hashCode(this.key));
    }

    public String toString() {
        return String.format("%s:%s", this.name, this.type.toString());
    }
}

