/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.treasuredata.client.model.JsonCollectionRootName;

@JsonCollectionRootName(value="bulk_imports")
public class TDBulkImportSession {
    private final String name;
    private final String databaseName;
    private final String tableName;
    private final ImportStatus status;
    private final boolean uploadFrozen;
    private final String jobId;
    private final long validRecords;
    private final long errorRecords;
    private final long validParts;
    private final long errorParts;

    @JsonCreator
    public TDBulkImportSession(@JsonProperty(value="name") String name, @JsonProperty(value="database") String databaseName, @JsonProperty(value="table") String tableName, @JsonProperty(value="status") ImportStatus status, @JsonProperty(value="upload_frozen") boolean uploadFrozen, @JsonProperty(value="job_id") String jobId, @JsonProperty(value="valid_records") long validRecords, @JsonProperty(value="error_records") long errorRecords, @JsonProperty(value="valid_parts") long validParts, @JsonProperty(value="error_parts") long errorParts) {
        this.name = name;
        this.databaseName = databaseName;
        this.tableName = tableName;
        this.status = status;
        this.uploadFrozen = uploadFrozen;
        this.jobId = jobId;
        this.validRecords = validRecords;
        this.errorRecords = errorRecords;
        this.validParts = validParts;
        this.errorParts = errorParts;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="database")
    public String getDatabaseName() {
        return this.databaseName;
    }

    @JsonProperty(value="table")
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public ImportStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="upload_frozen")
    public boolean isUploadFrozen() {
        return this.uploadFrozen;
    }

    @JsonProperty(value="job_id")
    public String getJobId() {
        return this.jobId;
    }

    @JsonProperty(value="valid_records")
    public long getValidRecords() {
        return this.validRecords;
    }

    @JsonProperty(value="error_records")
    public long getErrorRecords() {
        return this.errorRecords;
    }

    @JsonProperty(value="valid_parts")
    public long getValidParts() {
        return this.validParts;
    }

    @JsonProperty(value="error_parts")
    public long getErrorParts() {
        return this.errorParts;
    }

    public boolean isUploading() {
        return this.status == ImportStatus.UPLOADING;
    }

    public boolean hasErrorOnPerform() {
        return this.validRecords == 0L || this.errorParts > 0L || this.errorRecords > 0L;
    }

    public String getErrorMessage() {
        if (this.validRecords == 0L) {
            return "No record processed";
        }
        if (this.errorRecords > 0L) {
            return String.format("%d invalid parts", this.errorParts);
        }
        if (this.errorRecords > 0L) {
            return String.format("%d invalid records", this.errorRecords);
        }
        return null;
    }

    public static enum ImportStatus {
        UPLOADING("uploading"),
        PERFORMING("performing"),
        READY("ready"),
        COMMITTING("committing"),
        COMMITTED("committed"),
        UNKNOWN("unknown");

        private final String name;

        private ImportStatus(String name) {
            this.name = name;
        }

        @JsonCreator
        public static ImportStatus forName(String name) {
            return ImportStatus.valueOf(name.toUpperCase());
        }
    }
}

