"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsInterfaceEndpoints = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const ec2 = require("aws-cdk-lib/aws-ec2");
const change_case_1 = require("change-case");
const constructs_1 = require("constructs");
class AwsInterfaceEndpoints extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const { exportPrefix = 'SessionManagerEndpoints', services } = props;
        const endpointProps = {
            vpc: props.vpc,
            subnets: props.subnets || { subnetType: ec2.SubnetType.PRIVATE_ISOLATED },
            open: typeof props.open !== 'undefined' ? props.open : true,
            securityGroups: props.securityGroups,
        };
        this.endpointServices = services.map(service => ({
            service: service.service,
            endpoint: this.defineEndpoint(this, service.id, {
                service: service.service,
                ...endpointProps,
                exportPrefix,
            }),
        }));
    }
    static fromAttributes(scope, id, props) {
        const { exportPrefix = 'SessionManagerEndpoints', services } = props;
        class Import extends aws_cdk_lib_1.Resource {
            constructor(_scope, _id) {
                super(_scope, _id);
                this.endpointServices = services.map(service => ({
                    service: service.service,
                    endpoint: ec2.InterfaceVpcEndpoint.fromInterfaceVpcEndpointAttributes(_scope, service.id, {
                        port: service.service.port,
                        vpcEndpointId: cdk.Fn.importValue(`${exportPrefix}/${change_case_1.pascalCase(service.id)}`),
                    }),
                }));
            }
            allowDefaultPromFrom(connectable) {
                this.endpointServices.forEach(endpointService => endpointService.endpoint.connections.allowDefaultPortFrom(connectable));
            }
        }
        return new Import(scope, id);
    }
    defineEndpoint(scope, id, props) {
        const endpoint = new ec2.InterfaceVpcEndpoint(scope, id, props);
        const tags = cdk.Tags.of(endpoint);
        tags.add('Name', endpoint.node.path);
        const { exportPrefix } = props;
        new cdk.CfnOutput(this, `vpcEndpointId${id}`, {
            value: endpoint.vpcEndpointId,
            exportName: `${exportPrefix}/${change_case_1.pascalCase(id)}`,
        });
        return endpoint;
    }
    allowDefaultPromFrom(connectable) {
        this.endpointServices.forEach(endpointService => endpointService.endpoint.connections.allowDefaultPortFrom(connectable));
    }
}
exports.AwsInterfaceEndpoints = AwsInterfaceEndpoints;
_a = JSII_RTTI_SYMBOL_1;
AwsInterfaceEndpoints[_a] = { fqn: "@alma-cdk/aws-interface-endpoints.AwsInterfaceEndpoints", version: "0.0.6" };
AwsInterfaceEndpoints.SessionManagerConnect = [
    { id: 'Ssm', service: ec2.InterfaceVpcEndpointAwsService.SSM },
    { id: 'Ec2Messages', service: ec2.InterfaceVpcEndpointAwsService.EC2_MESSAGES },
    { id: 'SsmMessages', service: ec2.InterfaceVpcEndpointAwsService.SSM_MESSAGES },
];
//# sourceMappingURL=data:application/json;base64,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