"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Project = exports.ProjectPushRulesOutputReference = exports.projectPushRulesToTerraform = exports.ProjectContainerExpirationPolicyOutputReference = exports.projectContainerExpirationPolicyToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function projectContainerExpirationPolicyToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        cadence: cdktf.stringToTerraform(struct.cadence),
        enabled: cdktf.booleanToTerraform(struct.enabled),
        keep_n: cdktf.numberToTerraform(struct.keepN),
        name_regex_delete: cdktf.stringToTerraform(struct.nameRegexDelete),
        name_regex_keep: cdktf.stringToTerraform(struct.nameRegexKeep),
        older_than: cdktf.stringToTerraform(struct.olderThan),
    };
}
exports.projectContainerExpirationPolicyToTerraform = projectContainerExpirationPolicyToTerraform;
class ProjectContainerExpirationPolicyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._cadence !== undefined) {
            hasAnyValues = true;
            internalValueResult.cadence = this._cadence;
        }
        if (this._enabled !== undefined) {
            hasAnyValues = true;
            internalValueResult.enabled = this._enabled;
        }
        if (this._keepN !== undefined) {
            hasAnyValues = true;
            internalValueResult.keepN = this._keepN;
        }
        if (this._nameRegexDelete !== undefined) {
            hasAnyValues = true;
            internalValueResult.nameRegexDelete = this._nameRegexDelete;
        }
        if (this._nameRegexKeep !== undefined) {
            hasAnyValues = true;
            internalValueResult.nameRegexKeep = this._nameRegexKeep;
        }
        if (this._olderThan !== undefined) {
            hasAnyValues = true;
            internalValueResult.olderThan = this._olderThan;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._cadence = undefined;
            this._enabled = undefined;
            this._keepN = undefined;
            this._nameRegexDelete = undefined;
            this._nameRegexKeep = undefined;
            this._olderThan = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._cadence = value.cadence;
            this._enabled = value.enabled;
            this._keepN = value.keepN;
            this._nameRegexDelete = value.nameRegexDelete;
            this._nameRegexKeep = value.nameRegexKeep;
            this._olderThan = value.olderThan;
        }
    }
    get cadence() {
        return this.getStringAttribute('cadence');
    }
    set cadence(value) {
        this._cadence = value;
    }
    resetCadence() {
        this._cadence = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cadenceInput() {
        return this._cadence;
    }
    get enabled() {
        return this.getBooleanAttribute('enabled');
    }
    set enabled(value) {
        this._enabled = value;
    }
    resetEnabled() {
        this._enabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enabledInput() {
        return this._enabled;
    }
    get keepN() {
        return this.getNumberAttribute('keep_n');
    }
    set keepN(value) {
        this._keepN = value;
    }
    resetKeepN() {
        this._keepN = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get keepNInput() {
        return this._keepN;
    }
    get nameRegexDelete() {
        return this.getStringAttribute('name_regex_delete');
    }
    set nameRegexDelete(value) {
        this._nameRegexDelete = value;
    }
    resetNameRegexDelete() {
        this._nameRegexDelete = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get nameRegexDeleteInput() {
        return this._nameRegexDelete;
    }
    get nameRegexKeep() {
        return this.getStringAttribute('name_regex_keep');
    }
    set nameRegexKeep(value) {
        this._nameRegexKeep = value;
    }
    resetNameRegexKeep() {
        this._nameRegexKeep = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get nameRegexKeepInput() {
        return this._nameRegexKeep;
    }
    // next_run_at - computed: true, optional: false, required: false
    get nextRunAt() {
        return this.getStringAttribute('next_run_at');
    }
    get olderThan() {
        return this.getStringAttribute('older_than');
    }
    set olderThan(value) {
        this._olderThan = value;
    }
    resetOlderThan() {
        this._olderThan = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get olderThanInput() {
        return this._olderThan;
    }
}
exports.ProjectContainerExpirationPolicyOutputReference = ProjectContainerExpirationPolicyOutputReference;
_a = JSII_RTTI_SYMBOL_1;
ProjectContainerExpirationPolicyOutputReference[_a] = { fqn: "@cdktf/provider-gitlab.ProjectContainerExpirationPolicyOutputReference", version: "0.1.13" };
function projectPushRulesToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        author_email_regex: cdktf.stringToTerraform(struct.authorEmailRegex),
        branch_name_regex: cdktf.stringToTerraform(struct.branchNameRegex),
        commit_committer_check: cdktf.booleanToTerraform(struct.commitCommitterCheck),
        commit_message_negative_regex: cdktf.stringToTerraform(struct.commitMessageNegativeRegex),
        commit_message_regex: cdktf.stringToTerraform(struct.commitMessageRegex),
        deny_delete_tag: cdktf.booleanToTerraform(struct.denyDeleteTag),
        file_name_regex: cdktf.stringToTerraform(struct.fileNameRegex),
        max_file_size: cdktf.numberToTerraform(struct.maxFileSize),
        member_check: cdktf.booleanToTerraform(struct.memberCheck),
        prevent_secrets: cdktf.booleanToTerraform(struct.preventSecrets),
        reject_unsigned_commits: cdktf.booleanToTerraform(struct.rejectUnsignedCommits),
    };
}
exports.projectPushRulesToTerraform = projectPushRulesToTerraform;
class ProjectPushRulesOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._authorEmailRegex !== undefined) {
            hasAnyValues = true;
            internalValueResult.authorEmailRegex = this._authorEmailRegex;
        }
        if (this._branchNameRegex !== undefined) {
            hasAnyValues = true;
            internalValueResult.branchNameRegex = this._branchNameRegex;
        }
        if (this._commitCommitterCheck !== undefined) {
            hasAnyValues = true;
            internalValueResult.commitCommitterCheck = this._commitCommitterCheck;
        }
        if (this._commitMessageNegativeRegex !== undefined) {
            hasAnyValues = true;
            internalValueResult.commitMessageNegativeRegex = this._commitMessageNegativeRegex;
        }
        if (this._commitMessageRegex !== undefined) {
            hasAnyValues = true;
            internalValueResult.commitMessageRegex = this._commitMessageRegex;
        }
        if (this._denyDeleteTag !== undefined) {
            hasAnyValues = true;
            internalValueResult.denyDeleteTag = this._denyDeleteTag;
        }
        if (this._fileNameRegex !== undefined) {
            hasAnyValues = true;
            internalValueResult.fileNameRegex = this._fileNameRegex;
        }
        if (this._maxFileSize !== undefined) {
            hasAnyValues = true;
            internalValueResult.maxFileSize = this._maxFileSize;
        }
        if (this._memberCheck !== undefined) {
            hasAnyValues = true;
            internalValueResult.memberCheck = this._memberCheck;
        }
        if (this._preventSecrets !== undefined) {
            hasAnyValues = true;
            internalValueResult.preventSecrets = this._preventSecrets;
        }
        if (this._rejectUnsignedCommits !== undefined) {
            hasAnyValues = true;
            internalValueResult.rejectUnsignedCommits = this._rejectUnsignedCommits;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._authorEmailRegex = undefined;
            this._branchNameRegex = undefined;
            this._commitCommitterCheck = undefined;
            this._commitMessageNegativeRegex = undefined;
            this._commitMessageRegex = undefined;
            this._denyDeleteTag = undefined;
            this._fileNameRegex = undefined;
            this._maxFileSize = undefined;
            this._memberCheck = undefined;
            this._preventSecrets = undefined;
            this._rejectUnsignedCommits = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._authorEmailRegex = value.authorEmailRegex;
            this._branchNameRegex = value.branchNameRegex;
            this._commitCommitterCheck = value.commitCommitterCheck;
            this._commitMessageNegativeRegex = value.commitMessageNegativeRegex;
            this._commitMessageRegex = value.commitMessageRegex;
            this._denyDeleteTag = value.denyDeleteTag;
            this._fileNameRegex = value.fileNameRegex;
            this._maxFileSize = value.maxFileSize;
            this._memberCheck = value.memberCheck;
            this._preventSecrets = value.preventSecrets;
            this._rejectUnsignedCommits = value.rejectUnsignedCommits;
        }
    }
    get authorEmailRegex() {
        return this.getStringAttribute('author_email_regex');
    }
    set authorEmailRegex(value) {
        this._authorEmailRegex = value;
    }
    resetAuthorEmailRegex() {
        this._authorEmailRegex = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get authorEmailRegexInput() {
        return this._authorEmailRegex;
    }
    get branchNameRegex() {
        return this.getStringAttribute('branch_name_regex');
    }
    set branchNameRegex(value) {
        this._branchNameRegex = value;
    }
    resetBranchNameRegex() {
        this._branchNameRegex = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get branchNameRegexInput() {
        return this._branchNameRegex;
    }
    get commitCommitterCheck() {
        return this.getBooleanAttribute('commit_committer_check');
    }
    set commitCommitterCheck(value) {
        this._commitCommitterCheck = value;
    }
    resetCommitCommitterCheck() {
        this._commitCommitterCheck = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get commitCommitterCheckInput() {
        return this._commitCommitterCheck;
    }
    get commitMessageNegativeRegex() {
        return this.getStringAttribute('commit_message_negative_regex');
    }
    set commitMessageNegativeRegex(value) {
        this._commitMessageNegativeRegex = value;
    }
    resetCommitMessageNegativeRegex() {
        this._commitMessageNegativeRegex = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get commitMessageNegativeRegexInput() {
        return this._commitMessageNegativeRegex;
    }
    get commitMessageRegex() {
        return this.getStringAttribute('commit_message_regex');
    }
    set commitMessageRegex(value) {
        this._commitMessageRegex = value;
    }
    resetCommitMessageRegex() {
        this._commitMessageRegex = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get commitMessageRegexInput() {
        return this._commitMessageRegex;
    }
    get denyDeleteTag() {
        return this.getBooleanAttribute('deny_delete_tag');
    }
    set denyDeleteTag(value) {
        this._denyDeleteTag = value;
    }
    resetDenyDeleteTag() {
        this._denyDeleteTag = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get denyDeleteTagInput() {
        return this._denyDeleteTag;
    }
    get fileNameRegex() {
        return this.getStringAttribute('file_name_regex');
    }
    set fileNameRegex(value) {
        this._fileNameRegex = value;
    }
    resetFileNameRegex() {
        this._fileNameRegex = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get fileNameRegexInput() {
        return this._fileNameRegex;
    }
    get maxFileSize() {
        return this.getNumberAttribute('max_file_size');
    }
    set maxFileSize(value) {
        this._maxFileSize = value;
    }
    resetMaxFileSize() {
        this._maxFileSize = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxFileSizeInput() {
        return this._maxFileSize;
    }
    get memberCheck() {
        return this.getBooleanAttribute('member_check');
    }
    set memberCheck(value) {
        this._memberCheck = value;
    }
    resetMemberCheck() {
        this._memberCheck = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get memberCheckInput() {
        return this._memberCheck;
    }
    get preventSecrets() {
        return this.getBooleanAttribute('prevent_secrets');
    }
    set preventSecrets(value) {
        this._preventSecrets = value;
    }
    resetPreventSecrets() {
        this._preventSecrets = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get preventSecretsInput() {
        return this._preventSecrets;
    }
    get rejectUnsignedCommits() {
        return this.getBooleanAttribute('reject_unsigned_commits');
    }
    set rejectUnsignedCommits(value) {
        this._rejectUnsignedCommits = value;
    }
    resetRejectUnsignedCommits() {
        this._rejectUnsignedCommits = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get rejectUnsignedCommitsInput() {
        return this._rejectUnsignedCommits;
    }
}
exports.ProjectPushRulesOutputReference = ProjectPushRulesOutputReference;
_b = JSII_RTTI_SYMBOL_1;
ProjectPushRulesOutputReference[_b] = { fqn: "@cdktf/provider-gitlab.ProjectPushRulesOutputReference", version: "0.1.13" };
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/project gitlab_project}
*/
class Project extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/r/project gitlab_project} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ProjectConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'gitlab_project',
            terraformGeneratorMetadata: {
                providerName: 'gitlab',
                providerVersion: '3.14.0',
                providerVersionConstraint: '~> 3.14.0'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        // container_expiration_policy - computed: false, optional: true, required: false
        this._containerExpirationPolicy = new ProjectContainerExpirationPolicyOutputReference(this, "container_expiration_policy");
        // push_rules - computed: false, optional: true, required: false
        this._pushRules = new ProjectPushRulesOutputReference(this, "push_rules");
        this._allowMergeOnSkippedPipeline = config.allowMergeOnSkippedPipeline;
        this._analyticsAccessLevel = config.analyticsAccessLevel;
        this._approvalsBeforeMerge = config.approvalsBeforeMerge;
        this._archiveOnDestroy = config.archiveOnDestroy;
        this._archived = config.archived;
        this._autoCancelPendingPipelines = config.autoCancelPendingPipelines;
        this._autoDevopsDeployStrategy = config.autoDevopsDeployStrategy;
        this._autoDevopsEnabled = config.autoDevopsEnabled;
        this._autocloseReferencedIssues = config.autocloseReferencedIssues;
        this._buildCoverageRegex = config.buildCoverageRegex;
        this._buildGitStrategy = config.buildGitStrategy;
        this._buildTimeout = config.buildTimeout;
        this._buildsAccessLevel = config.buildsAccessLevel;
        this._ciConfigPath = config.ciConfigPath;
        this._ciForwardDeploymentEnabled = config.ciForwardDeploymentEnabled;
        this._containerRegistryAccessLevel = config.containerRegistryAccessLevel;
        this._containerRegistryEnabled = config.containerRegistryEnabled;
        this._defaultBranch = config.defaultBranch;
        this._description = config.description;
        this._emailsDisabled = config.emailsDisabled;
        this._externalAuthorizationClassificationLabel = config.externalAuthorizationClassificationLabel;
        this._forkingAccessLevel = config.forkingAccessLevel;
        this._groupWithProjectTemplatesId = config.groupWithProjectTemplatesId;
        this._id = config.id;
        this._importUrl = config.importUrl;
        this._initializeWithReadme = config.initializeWithReadme;
        this._issuesAccessLevel = config.issuesAccessLevel;
        this._issuesEnabled = config.issuesEnabled;
        this._issuesTemplate = config.issuesTemplate;
        this._lfsEnabled = config.lfsEnabled;
        this._mergeCommitTemplate = config.mergeCommitTemplate;
        this._mergeMethod = config.mergeMethod;
        this._mergePipelinesEnabled = config.mergePipelinesEnabled;
        this._mergeRequestsAccessLevel = config.mergeRequestsAccessLevel;
        this._mergeRequestsEnabled = config.mergeRequestsEnabled;
        this._mergeRequestsTemplate = config.mergeRequestsTemplate;
        this._mergeTrainsEnabled = config.mergeTrainsEnabled;
        this._mirror = config.mirror;
        this._mirrorOverwritesDivergedBranches = config.mirrorOverwritesDivergedBranches;
        this._mirrorTriggerBuilds = config.mirrorTriggerBuilds;
        this._name = config.name;
        this._namespaceId = config.namespaceId;
        this._onlyAllowMergeIfAllDiscussionsAreResolved = config.onlyAllowMergeIfAllDiscussionsAreResolved;
        this._onlyAllowMergeIfPipelineSucceeds = config.onlyAllowMergeIfPipelineSucceeds;
        this._onlyMirrorProtectedBranches = config.onlyMirrorProtectedBranches;
        this._operationsAccessLevel = config.operationsAccessLevel;
        this._packagesEnabled = config.packagesEnabled;
        this._pagesAccessLevel = config.pagesAccessLevel;
        this._path = config.path;
        this._pipelinesEnabled = config.pipelinesEnabled;
        this._printingMergeRequestLinkEnabled = config.printingMergeRequestLinkEnabled;
        this._publicBuilds = config.publicBuilds;
        this._removeSourceBranchAfterMerge = config.removeSourceBranchAfterMerge;
        this._repositoryAccessLevel = config.repositoryAccessLevel;
        this._repositoryStorage = config.repositoryStorage;
        this._requestAccessEnabled = config.requestAccessEnabled;
        this._requirementsAccessLevel = config.requirementsAccessLevel;
        this._resolveOutdatedDiffDiscussions = config.resolveOutdatedDiffDiscussions;
        this._securityAndComplianceAccessLevel = config.securityAndComplianceAccessLevel;
        this._sharedRunnersEnabled = config.sharedRunnersEnabled;
        this._snippetsAccessLevel = config.snippetsAccessLevel;
        this._snippetsEnabled = config.snippetsEnabled;
        this._squashCommitTemplate = config.squashCommitTemplate;
        this._squashOption = config.squashOption;
        this._tags = config.tags;
        this._templateName = config.templateName;
        this._templateProjectId = config.templateProjectId;
        this._topics = config.topics;
        this._useCustomTemplate = config.useCustomTemplate;
        this._visibilityLevel = config.visibilityLevel;
        this._wikiAccessLevel = config.wikiAccessLevel;
        this._wikiEnabled = config.wikiEnabled;
        this._containerExpirationPolicy.internalValue = config.containerExpirationPolicy;
        this._pushRules.internalValue = config.pushRules;
    }
    get allowMergeOnSkippedPipeline() {
        return this.getBooleanAttribute('allow_merge_on_skipped_pipeline');
    }
    set allowMergeOnSkippedPipeline(value) {
        this._allowMergeOnSkippedPipeline = value;
    }
    resetAllowMergeOnSkippedPipeline() {
        this._allowMergeOnSkippedPipeline = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowMergeOnSkippedPipelineInput() {
        return this._allowMergeOnSkippedPipeline;
    }
    get analyticsAccessLevel() {
        return this.getStringAttribute('analytics_access_level');
    }
    set analyticsAccessLevel(value) {
        this._analyticsAccessLevel = value;
    }
    resetAnalyticsAccessLevel() {
        this._analyticsAccessLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get analyticsAccessLevelInput() {
        return this._analyticsAccessLevel;
    }
    get approvalsBeforeMerge() {
        return this.getNumberAttribute('approvals_before_merge');
    }
    set approvalsBeforeMerge(value) {
        this._approvalsBeforeMerge = value;
    }
    resetApprovalsBeforeMerge() {
        this._approvalsBeforeMerge = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get approvalsBeforeMergeInput() {
        return this._approvalsBeforeMerge;
    }
    get archiveOnDestroy() {
        return this.getBooleanAttribute('archive_on_destroy');
    }
    set archiveOnDestroy(value) {
        this._archiveOnDestroy = value;
    }
    resetArchiveOnDestroy() {
        this._archiveOnDestroy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get archiveOnDestroyInput() {
        return this._archiveOnDestroy;
    }
    get archived() {
        return this.getBooleanAttribute('archived');
    }
    set archived(value) {
        this._archived = value;
    }
    resetArchived() {
        this._archived = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get archivedInput() {
        return this._archived;
    }
    get autoCancelPendingPipelines() {
        return this.getStringAttribute('auto_cancel_pending_pipelines');
    }
    set autoCancelPendingPipelines(value) {
        this._autoCancelPendingPipelines = value;
    }
    resetAutoCancelPendingPipelines() {
        this._autoCancelPendingPipelines = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get autoCancelPendingPipelinesInput() {
        return this._autoCancelPendingPipelines;
    }
    get autoDevopsDeployStrategy() {
        return this.getStringAttribute('auto_devops_deploy_strategy');
    }
    set autoDevopsDeployStrategy(value) {
        this._autoDevopsDeployStrategy = value;
    }
    resetAutoDevopsDeployStrategy() {
        this._autoDevopsDeployStrategy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get autoDevopsDeployStrategyInput() {
        return this._autoDevopsDeployStrategy;
    }
    get autoDevopsEnabled() {
        return this.getBooleanAttribute('auto_devops_enabled');
    }
    set autoDevopsEnabled(value) {
        this._autoDevopsEnabled = value;
    }
    resetAutoDevopsEnabled() {
        this._autoDevopsEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get autoDevopsEnabledInput() {
        return this._autoDevopsEnabled;
    }
    get autocloseReferencedIssues() {
        return this.getBooleanAttribute('autoclose_referenced_issues');
    }
    set autocloseReferencedIssues(value) {
        this._autocloseReferencedIssues = value;
    }
    resetAutocloseReferencedIssues() {
        this._autocloseReferencedIssues = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get autocloseReferencedIssuesInput() {
        return this._autocloseReferencedIssues;
    }
    get buildCoverageRegex() {
        return this.getStringAttribute('build_coverage_regex');
    }
    set buildCoverageRegex(value) {
        this._buildCoverageRegex = value;
    }
    resetBuildCoverageRegex() {
        this._buildCoverageRegex = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get buildCoverageRegexInput() {
        return this._buildCoverageRegex;
    }
    get buildGitStrategy() {
        return this.getStringAttribute('build_git_strategy');
    }
    set buildGitStrategy(value) {
        this._buildGitStrategy = value;
    }
    resetBuildGitStrategy() {
        this._buildGitStrategy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get buildGitStrategyInput() {
        return this._buildGitStrategy;
    }
    get buildTimeout() {
        return this.getNumberAttribute('build_timeout');
    }
    set buildTimeout(value) {
        this._buildTimeout = value;
    }
    resetBuildTimeout() {
        this._buildTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get buildTimeoutInput() {
        return this._buildTimeout;
    }
    get buildsAccessLevel() {
        return this.getStringAttribute('builds_access_level');
    }
    set buildsAccessLevel(value) {
        this._buildsAccessLevel = value;
    }
    resetBuildsAccessLevel() {
        this._buildsAccessLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get buildsAccessLevelInput() {
        return this._buildsAccessLevel;
    }
    get ciConfigPath() {
        return this.getStringAttribute('ci_config_path');
    }
    set ciConfigPath(value) {
        this._ciConfigPath = value;
    }
    resetCiConfigPath() {
        this._ciConfigPath = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ciConfigPathInput() {
        return this._ciConfigPath;
    }
    get ciForwardDeploymentEnabled() {
        return this.getBooleanAttribute('ci_forward_deployment_enabled');
    }
    set ciForwardDeploymentEnabled(value) {
        this._ciForwardDeploymentEnabled = value;
    }
    resetCiForwardDeploymentEnabled() {
        this._ciForwardDeploymentEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ciForwardDeploymentEnabledInput() {
        return this._ciForwardDeploymentEnabled;
    }
    get containerRegistryAccessLevel() {
        return this.getStringAttribute('container_registry_access_level');
    }
    set containerRegistryAccessLevel(value) {
        this._containerRegistryAccessLevel = value;
    }
    resetContainerRegistryAccessLevel() {
        this._containerRegistryAccessLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get containerRegistryAccessLevelInput() {
        return this._containerRegistryAccessLevel;
    }
    get containerRegistryEnabled() {
        return this.getBooleanAttribute('container_registry_enabled');
    }
    set containerRegistryEnabled(value) {
        this._containerRegistryEnabled = value;
    }
    resetContainerRegistryEnabled() {
        this._containerRegistryEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get containerRegistryEnabledInput() {
        return this._containerRegistryEnabled;
    }
    get defaultBranch() {
        return this.getStringAttribute('default_branch');
    }
    set defaultBranch(value) {
        this._defaultBranch = value;
    }
    resetDefaultBranch() {
        this._defaultBranch = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get defaultBranchInput() {
        return this._defaultBranch;
    }
    get description() {
        return this.getStringAttribute('description');
    }
    set description(value) {
        this._description = value;
    }
    resetDescription() {
        this._description = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get descriptionInput() {
        return this._description;
    }
    get emailsDisabled() {
        return this.getBooleanAttribute('emails_disabled');
    }
    set emailsDisabled(value) {
        this._emailsDisabled = value;
    }
    resetEmailsDisabled() {
        this._emailsDisabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get emailsDisabledInput() {
        return this._emailsDisabled;
    }
    get externalAuthorizationClassificationLabel() {
        return this.getStringAttribute('external_authorization_classification_label');
    }
    set externalAuthorizationClassificationLabel(value) {
        this._externalAuthorizationClassificationLabel = value;
    }
    resetExternalAuthorizationClassificationLabel() {
        this._externalAuthorizationClassificationLabel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get externalAuthorizationClassificationLabelInput() {
        return this._externalAuthorizationClassificationLabel;
    }
    get forkingAccessLevel() {
        return this.getStringAttribute('forking_access_level');
    }
    set forkingAccessLevel(value) {
        this._forkingAccessLevel = value;
    }
    resetForkingAccessLevel() {
        this._forkingAccessLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get forkingAccessLevelInput() {
        return this._forkingAccessLevel;
    }
    get groupWithProjectTemplatesId() {
        return this.getNumberAttribute('group_with_project_templates_id');
    }
    set groupWithProjectTemplatesId(value) {
        this._groupWithProjectTemplatesId = value;
    }
    resetGroupWithProjectTemplatesId() {
        this._groupWithProjectTemplatesId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get groupWithProjectTemplatesIdInput() {
        return this._groupWithProjectTemplatesId;
    }
    // http_url_to_repo - computed: true, optional: false, required: false
    get httpUrlToRepo() {
        return this.getStringAttribute('http_url_to_repo');
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get importUrl() {
        return this.getStringAttribute('import_url');
    }
    set importUrl(value) {
        this._importUrl = value;
    }
    resetImportUrl() {
        this._importUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get importUrlInput() {
        return this._importUrl;
    }
    get initializeWithReadme() {
        return this.getBooleanAttribute('initialize_with_readme');
    }
    set initializeWithReadme(value) {
        this._initializeWithReadme = value;
    }
    resetInitializeWithReadme() {
        this._initializeWithReadme = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get initializeWithReadmeInput() {
        return this._initializeWithReadme;
    }
    get issuesAccessLevel() {
        return this.getStringAttribute('issues_access_level');
    }
    set issuesAccessLevel(value) {
        this._issuesAccessLevel = value;
    }
    resetIssuesAccessLevel() {
        this._issuesAccessLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get issuesAccessLevelInput() {
        return this._issuesAccessLevel;
    }
    get issuesEnabled() {
        return this.getBooleanAttribute('issues_enabled');
    }
    set issuesEnabled(value) {
        this._issuesEnabled = value;
    }
    resetIssuesEnabled() {
        this._issuesEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get issuesEnabledInput() {
        return this._issuesEnabled;
    }
    get issuesTemplate() {
        return this.getStringAttribute('issues_template');
    }
    set issuesTemplate(value) {
        this._issuesTemplate = value;
    }
    resetIssuesTemplate() {
        this._issuesTemplate = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get issuesTemplateInput() {
        return this._issuesTemplate;
    }
    get lfsEnabled() {
        return this.getBooleanAttribute('lfs_enabled');
    }
    set lfsEnabled(value) {
        this._lfsEnabled = value;
    }
    resetLfsEnabled() {
        this._lfsEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get lfsEnabledInput() {
        return this._lfsEnabled;
    }
    get mergeCommitTemplate() {
        return this.getStringAttribute('merge_commit_template');
    }
    set mergeCommitTemplate(value) {
        this._mergeCommitTemplate = value;
    }
    resetMergeCommitTemplate() {
        this._mergeCommitTemplate = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mergeCommitTemplateInput() {
        return this._mergeCommitTemplate;
    }
    get mergeMethod() {
        return this.getStringAttribute('merge_method');
    }
    set mergeMethod(value) {
        this._mergeMethod = value;
    }
    resetMergeMethod() {
        this._mergeMethod = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mergeMethodInput() {
        return this._mergeMethod;
    }
    get mergePipelinesEnabled() {
        return this.getBooleanAttribute('merge_pipelines_enabled');
    }
    set mergePipelinesEnabled(value) {
        this._mergePipelinesEnabled = value;
    }
    resetMergePipelinesEnabled() {
        this._mergePipelinesEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mergePipelinesEnabledInput() {
        return this._mergePipelinesEnabled;
    }
    get mergeRequestsAccessLevel() {
        return this.getStringAttribute('merge_requests_access_level');
    }
    set mergeRequestsAccessLevel(value) {
        this._mergeRequestsAccessLevel = value;
    }
    resetMergeRequestsAccessLevel() {
        this._mergeRequestsAccessLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mergeRequestsAccessLevelInput() {
        return this._mergeRequestsAccessLevel;
    }
    get mergeRequestsEnabled() {
        return this.getBooleanAttribute('merge_requests_enabled');
    }
    set mergeRequestsEnabled(value) {
        this._mergeRequestsEnabled = value;
    }
    resetMergeRequestsEnabled() {
        this._mergeRequestsEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mergeRequestsEnabledInput() {
        return this._mergeRequestsEnabled;
    }
    get mergeRequestsTemplate() {
        return this.getStringAttribute('merge_requests_template');
    }
    set mergeRequestsTemplate(value) {
        this._mergeRequestsTemplate = value;
    }
    resetMergeRequestsTemplate() {
        this._mergeRequestsTemplate = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mergeRequestsTemplateInput() {
        return this._mergeRequestsTemplate;
    }
    get mergeTrainsEnabled() {
        return this.getBooleanAttribute('merge_trains_enabled');
    }
    set mergeTrainsEnabled(value) {
        this._mergeTrainsEnabled = value;
    }
    resetMergeTrainsEnabled() {
        this._mergeTrainsEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mergeTrainsEnabledInput() {
        return this._mergeTrainsEnabled;
    }
    get mirror() {
        return this.getBooleanAttribute('mirror');
    }
    set mirror(value) {
        this._mirror = value;
    }
    resetMirror() {
        this._mirror = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mirrorInput() {
        return this._mirror;
    }
    get mirrorOverwritesDivergedBranches() {
        return this.getBooleanAttribute('mirror_overwrites_diverged_branches');
    }
    set mirrorOverwritesDivergedBranches(value) {
        this._mirrorOverwritesDivergedBranches = value;
    }
    resetMirrorOverwritesDivergedBranches() {
        this._mirrorOverwritesDivergedBranches = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mirrorOverwritesDivergedBranchesInput() {
        return this._mirrorOverwritesDivergedBranches;
    }
    get mirrorTriggerBuilds() {
        return this.getBooleanAttribute('mirror_trigger_builds');
    }
    set mirrorTriggerBuilds(value) {
        this._mirrorTriggerBuilds = value;
    }
    resetMirrorTriggerBuilds() {
        this._mirrorTriggerBuilds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mirrorTriggerBuildsInput() {
        return this._mirrorTriggerBuilds;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get namespaceId() {
        return this.getNumberAttribute('namespace_id');
    }
    set namespaceId(value) {
        this._namespaceId = value;
    }
    resetNamespaceId() {
        this._namespaceId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get namespaceIdInput() {
        return this._namespaceId;
    }
    get onlyAllowMergeIfAllDiscussionsAreResolved() {
        return this.getBooleanAttribute('only_allow_merge_if_all_discussions_are_resolved');
    }
    set onlyAllowMergeIfAllDiscussionsAreResolved(value) {
        this._onlyAllowMergeIfAllDiscussionsAreResolved = value;
    }
    resetOnlyAllowMergeIfAllDiscussionsAreResolved() {
        this._onlyAllowMergeIfAllDiscussionsAreResolved = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get onlyAllowMergeIfAllDiscussionsAreResolvedInput() {
        return this._onlyAllowMergeIfAllDiscussionsAreResolved;
    }
    get onlyAllowMergeIfPipelineSucceeds() {
        return this.getBooleanAttribute('only_allow_merge_if_pipeline_succeeds');
    }
    set onlyAllowMergeIfPipelineSucceeds(value) {
        this._onlyAllowMergeIfPipelineSucceeds = value;
    }
    resetOnlyAllowMergeIfPipelineSucceeds() {
        this._onlyAllowMergeIfPipelineSucceeds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get onlyAllowMergeIfPipelineSucceedsInput() {
        return this._onlyAllowMergeIfPipelineSucceeds;
    }
    get onlyMirrorProtectedBranches() {
        return this.getBooleanAttribute('only_mirror_protected_branches');
    }
    set onlyMirrorProtectedBranches(value) {
        this._onlyMirrorProtectedBranches = value;
    }
    resetOnlyMirrorProtectedBranches() {
        this._onlyMirrorProtectedBranches = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get onlyMirrorProtectedBranchesInput() {
        return this._onlyMirrorProtectedBranches;
    }
    get operationsAccessLevel() {
        return this.getStringAttribute('operations_access_level');
    }
    set operationsAccessLevel(value) {
        this._operationsAccessLevel = value;
    }
    resetOperationsAccessLevel() {
        this._operationsAccessLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get operationsAccessLevelInput() {
        return this._operationsAccessLevel;
    }
    get packagesEnabled() {
        return this.getBooleanAttribute('packages_enabled');
    }
    set packagesEnabled(value) {
        this._packagesEnabled = value;
    }
    resetPackagesEnabled() {
        this._packagesEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get packagesEnabledInput() {
        return this._packagesEnabled;
    }
    get pagesAccessLevel() {
        return this.getStringAttribute('pages_access_level');
    }
    set pagesAccessLevel(value) {
        this._pagesAccessLevel = value;
    }
    resetPagesAccessLevel() {
        this._pagesAccessLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pagesAccessLevelInput() {
        return this._pagesAccessLevel;
    }
    get path() {
        return this.getStringAttribute('path');
    }
    set path(value) {
        this._path = value;
    }
    resetPath() {
        this._path = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pathInput() {
        return this._path;
    }
    // path_with_namespace - computed: true, optional: false, required: false
    get pathWithNamespace() {
        return this.getStringAttribute('path_with_namespace');
    }
    get pipelinesEnabled() {
        return this.getBooleanAttribute('pipelines_enabled');
    }
    set pipelinesEnabled(value) {
        this._pipelinesEnabled = value;
    }
    resetPipelinesEnabled() {
        this._pipelinesEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pipelinesEnabledInput() {
        return this._pipelinesEnabled;
    }
    get printingMergeRequestLinkEnabled() {
        return this.getBooleanAttribute('printing_merge_request_link_enabled');
    }
    set printingMergeRequestLinkEnabled(value) {
        this._printingMergeRequestLinkEnabled = value;
    }
    resetPrintingMergeRequestLinkEnabled() {
        this._printingMergeRequestLinkEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get printingMergeRequestLinkEnabledInput() {
        return this._printingMergeRequestLinkEnabled;
    }
    get publicBuilds() {
        return this.getBooleanAttribute('public_builds');
    }
    set publicBuilds(value) {
        this._publicBuilds = value;
    }
    resetPublicBuilds() {
        this._publicBuilds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get publicBuildsInput() {
        return this._publicBuilds;
    }
    get removeSourceBranchAfterMerge() {
        return this.getBooleanAttribute('remove_source_branch_after_merge');
    }
    set removeSourceBranchAfterMerge(value) {
        this._removeSourceBranchAfterMerge = value;
    }
    resetRemoveSourceBranchAfterMerge() {
        this._removeSourceBranchAfterMerge = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get removeSourceBranchAfterMergeInput() {
        return this._removeSourceBranchAfterMerge;
    }
    get repositoryAccessLevel() {
        return this.getStringAttribute('repository_access_level');
    }
    set repositoryAccessLevel(value) {
        this._repositoryAccessLevel = value;
    }
    resetRepositoryAccessLevel() {
        this._repositoryAccessLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get repositoryAccessLevelInput() {
        return this._repositoryAccessLevel;
    }
    get repositoryStorage() {
        return this.getStringAttribute('repository_storage');
    }
    set repositoryStorage(value) {
        this._repositoryStorage = value;
    }
    resetRepositoryStorage() {
        this._repositoryStorage = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get repositoryStorageInput() {
        return this._repositoryStorage;
    }
    get requestAccessEnabled() {
        return this.getBooleanAttribute('request_access_enabled');
    }
    set requestAccessEnabled(value) {
        this._requestAccessEnabled = value;
    }
    resetRequestAccessEnabled() {
        this._requestAccessEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get requestAccessEnabledInput() {
        return this._requestAccessEnabled;
    }
    get requirementsAccessLevel() {
        return this.getStringAttribute('requirements_access_level');
    }
    set requirementsAccessLevel(value) {
        this._requirementsAccessLevel = value;
    }
    resetRequirementsAccessLevel() {
        this._requirementsAccessLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get requirementsAccessLevelInput() {
        return this._requirementsAccessLevel;
    }
    get resolveOutdatedDiffDiscussions() {
        return this.getBooleanAttribute('resolve_outdated_diff_discussions');
    }
    set resolveOutdatedDiffDiscussions(value) {
        this._resolveOutdatedDiffDiscussions = value;
    }
    resetResolveOutdatedDiffDiscussions() {
        this._resolveOutdatedDiffDiscussions = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get resolveOutdatedDiffDiscussionsInput() {
        return this._resolveOutdatedDiffDiscussions;
    }
    // runners_token - computed: true, optional: false, required: false
    get runnersToken() {
        return this.getStringAttribute('runners_token');
    }
    get securityAndComplianceAccessLevel() {
        return this.getStringAttribute('security_and_compliance_access_level');
    }
    set securityAndComplianceAccessLevel(value) {
        this._securityAndComplianceAccessLevel = value;
    }
    resetSecurityAndComplianceAccessLevel() {
        this._securityAndComplianceAccessLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get securityAndComplianceAccessLevelInput() {
        return this._securityAndComplianceAccessLevel;
    }
    get sharedRunnersEnabled() {
        return this.getBooleanAttribute('shared_runners_enabled');
    }
    set sharedRunnersEnabled(value) {
        this._sharedRunnersEnabled = value;
    }
    resetSharedRunnersEnabled() {
        this._sharedRunnersEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sharedRunnersEnabledInput() {
        return this._sharedRunnersEnabled;
    }
    get snippetsAccessLevel() {
        return this.getStringAttribute('snippets_access_level');
    }
    set snippetsAccessLevel(value) {
        this._snippetsAccessLevel = value;
    }
    resetSnippetsAccessLevel() {
        this._snippetsAccessLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get snippetsAccessLevelInput() {
        return this._snippetsAccessLevel;
    }
    get snippetsEnabled() {
        return this.getBooleanAttribute('snippets_enabled');
    }
    set snippetsEnabled(value) {
        this._snippetsEnabled = value;
    }
    resetSnippetsEnabled() {
        this._snippetsEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get snippetsEnabledInput() {
        return this._snippetsEnabled;
    }
    get squashCommitTemplate() {
        return this.getStringAttribute('squash_commit_template');
    }
    set squashCommitTemplate(value) {
        this._squashCommitTemplate = value;
    }
    resetSquashCommitTemplate() {
        this._squashCommitTemplate = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get squashCommitTemplateInput() {
        return this._squashCommitTemplate;
    }
    get squashOption() {
        return this.getStringAttribute('squash_option');
    }
    set squashOption(value) {
        this._squashOption = value;
    }
    resetSquashOption() {
        this._squashOption = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get squashOptionInput() {
        return this._squashOption;
    }
    // ssh_url_to_repo - computed: true, optional: false, required: false
    get sshUrlToRepo() {
        return this.getStringAttribute('ssh_url_to_repo');
    }
    get tags() {
        return cdktf.Fn.tolist(this.getListAttribute('tags'));
    }
    set tags(value) {
        this._tags = value;
    }
    resetTags() {
        this._tags = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tagsInput() {
        return this._tags;
    }
    get templateName() {
        return this.getStringAttribute('template_name');
    }
    set templateName(value) {
        this._templateName = value;
    }
    resetTemplateName() {
        this._templateName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get templateNameInput() {
        return this._templateName;
    }
    get templateProjectId() {
        return this.getNumberAttribute('template_project_id');
    }
    set templateProjectId(value) {
        this._templateProjectId = value;
    }
    resetTemplateProjectId() {
        this._templateProjectId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get templateProjectIdInput() {
        return this._templateProjectId;
    }
    get topics() {
        return cdktf.Fn.tolist(this.getListAttribute('topics'));
    }
    set topics(value) {
        this._topics = value;
    }
    resetTopics() {
        this._topics = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get topicsInput() {
        return this._topics;
    }
    get useCustomTemplate() {
        return this.getBooleanAttribute('use_custom_template');
    }
    set useCustomTemplate(value) {
        this._useCustomTemplate = value;
    }
    resetUseCustomTemplate() {
        this._useCustomTemplate = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get useCustomTemplateInput() {
        return this._useCustomTemplate;
    }
    get visibilityLevel() {
        return this.getStringAttribute('visibility_level');
    }
    set visibilityLevel(value) {
        this._visibilityLevel = value;
    }
    resetVisibilityLevel() {
        this._visibilityLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get visibilityLevelInput() {
        return this._visibilityLevel;
    }
    // web_url - computed: true, optional: false, required: false
    get webUrl() {
        return this.getStringAttribute('web_url');
    }
    get wikiAccessLevel() {
        return this.getStringAttribute('wiki_access_level');
    }
    set wikiAccessLevel(value) {
        this._wikiAccessLevel = value;
    }
    resetWikiAccessLevel() {
        this._wikiAccessLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get wikiAccessLevelInput() {
        return this._wikiAccessLevel;
    }
    get wikiEnabled() {
        return this.getBooleanAttribute('wiki_enabled');
    }
    set wikiEnabled(value) {
        this._wikiEnabled = value;
    }
    resetWikiEnabled() {
        this._wikiEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get wikiEnabledInput() {
        return this._wikiEnabled;
    }
    get containerExpirationPolicy() {
        return this._containerExpirationPolicy;
    }
    putContainerExpirationPolicy(value) {
        this._containerExpirationPolicy.internalValue = value;
    }
    resetContainerExpirationPolicy() {
        this._containerExpirationPolicy.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get containerExpirationPolicyInput() {
        return this._containerExpirationPolicy.internalValue;
    }
    get pushRules() {
        return this._pushRules;
    }
    putPushRules(value) {
        this._pushRules.internalValue = value;
    }
    resetPushRules() {
        this._pushRules.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pushRulesInput() {
        return this._pushRules.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            allow_merge_on_skipped_pipeline: cdktf.booleanToTerraform(this._allowMergeOnSkippedPipeline),
            analytics_access_level: cdktf.stringToTerraform(this._analyticsAccessLevel),
            approvals_before_merge: cdktf.numberToTerraform(this._approvalsBeforeMerge),
            archive_on_destroy: cdktf.booleanToTerraform(this._archiveOnDestroy),
            archived: cdktf.booleanToTerraform(this._archived),
            auto_cancel_pending_pipelines: cdktf.stringToTerraform(this._autoCancelPendingPipelines),
            auto_devops_deploy_strategy: cdktf.stringToTerraform(this._autoDevopsDeployStrategy),
            auto_devops_enabled: cdktf.booleanToTerraform(this._autoDevopsEnabled),
            autoclose_referenced_issues: cdktf.booleanToTerraform(this._autocloseReferencedIssues),
            build_coverage_regex: cdktf.stringToTerraform(this._buildCoverageRegex),
            build_git_strategy: cdktf.stringToTerraform(this._buildGitStrategy),
            build_timeout: cdktf.numberToTerraform(this._buildTimeout),
            builds_access_level: cdktf.stringToTerraform(this._buildsAccessLevel),
            ci_config_path: cdktf.stringToTerraform(this._ciConfigPath),
            ci_forward_deployment_enabled: cdktf.booleanToTerraform(this._ciForwardDeploymentEnabled),
            container_registry_access_level: cdktf.stringToTerraform(this._containerRegistryAccessLevel),
            container_registry_enabled: cdktf.booleanToTerraform(this._containerRegistryEnabled),
            default_branch: cdktf.stringToTerraform(this._defaultBranch),
            description: cdktf.stringToTerraform(this._description),
            emails_disabled: cdktf.booleanToTerraform(this._emailsDisabled),
            external_authorization_classification_label: cdktf.stringToTerraform(this._externalAuthorizationClassificationLabel),
            forking_access_level: cdktf.stringToTerraform(this._forkingAccessLevel),
            group_with_project_templates_id: cdktf.numberToTerraform(this._groupWithProjectTemplatesId),
            id: cdktf.stringToTerraform(this._id),
            import_url: cdktf.stringToTerraform(this._importUrl),
            initialize_with_readme: cdktf.booleanToTerraform(this._initializeWithReadme),
            issues_access_level: cdktf.stringToTerraform(this._issuesAccessLevel),
            issues_enabled: cdktf.booleanToTerraform(this._issuesEnabled),
            issues_template: cdktf.stringToTerraform(this._issuesTemplate),
            lfs_enabled: cdktf.booleanToTerraform(this._lfsEnabled),
            merge_commit_template: cdktf.stringToTerraform(this._mergeCommitTemplate),
            merge_method: cdktf.stringToTerraform(this._mergeMethod),
            merge_pipelines_enabled: cdktf.booleanToTerraform(this._mergePipelinesEnabled),
            merge_requests_access_level: cdktf.stringToTerraform(this._mergeRequestsAccessLevel),
            merge_requests_enabled: cdktf.booleanToTerraform(this._mergeRequestsEnabled),
            merge_requests_template: cdktf.stringToTerraform(this._mergeRequestsTemplate),
            merge_trains_enabled: cdktf.booleanToTerraform(this._mergeTrainsEnabled),
            mirror: cdktf.booleanToTerraform(this._mirror),
            mirror_overwrites_diverged_branches: cdktf.booleanToTerraform(this._mirrorOverwritesDivergedBranches),
            mirror_trigger_builds: cdktf.booleanToTerraform(this._mirrorTriggerBuilds),
            name: cdktf.stringToTerraform(this._name),
            namespace_id: cdktf.numberToTerraform(this._namespaceId),
            only_allow_merge_if_all_discussions_are_resolved: cdktf.booleanToTerraform(this._onlyAllowMergeIfAllDiscussionsAreResolved),
            only_allow_merge_if_pipeline_succeeds: cdktf.booleanToTerraform(this._onlyAllowMergeIfPipelineSucceeds),
            only_mirror_protected_branches: cdktf.booleanToTerraform(this._onlyMirrorProtectedBranches),
            operations_access_level: cdktf.stringToTerraform(this._operationsAccessLevel),
            packages_enabled: cdktf.booleanToTerraform(this._packagesEnabled),
            pages_access_level: cdktf.stringToTerraform(this._pagesAccessLevel),
            path: cdktf.stringToTerraform(this._path),
            pipelines_enabled: cdktf.booleanToTerraform(this._pipelinesEnabled),
            printing_merge_request_link_enabled: cdktf.booleanToTerraform(this._printingMergeRequestLinkEnabled),
            public_builds: cdktf.booleanToTerraform(this._publicBuilds),
            remove_source_branch_after_merge: cdktf.booleanToTerraform(this._removeSourceBranchAfterMerge),
            repository_access_level: cdktf.stringToTerraform(this._repositoryAccessLevel),
            repository_storage: cdktf.stringToTerraform(this._repositoryStorage),
            request_access_enabled: cdktf.booleanToTerraform(this._requestAccessEnabled),
            requirements_access_level: cdktf.stringToTerraform(this._requirementsAccessLevel),
            resolve_outdated_diff_discussions: cdktf.booleanToTerraform(this._resolveOutdatedDiffDiscussions),
            security_and_compliance_access_level: cdktf.stringToTerraform(this._securityAndComplianceAccessLevel),
            shared_runners_enabled: cdktf.booleanToTerraform(this._sharedRunnersEnabled),
            snippets_access_level: cdktf.stringToTerraform(this._snippetsAccessLevel),
            snippets_enabled: cdktf.booleanToTerraform(this._snippetsEnabled),
            squash_commit_template: cdktf.stringToTerraform(this._squashCommitTemplate),
            squash_option: cdktf.stringToTerraform(this._squashOption),
            tags: cdktf.listMapper(cdktf.stringToTerraform)(this._tags),
            template_name: cdktf.stringToTerraform(this._templateName),
            template_project_id: cdktf.numberToTerraform(this._templateProjectId),
            topics: cdktf.listMapper(cdktf.stringToTerraform)(this._topics),
            use_custom_template: cdktf.booleanToTerraform(this._useCustomTemplate),
            visibility_level: cdktf.stringToTerraform(this._visibilityLevel),
            wiki_access_level: cdktf.stringToTerraform(this._wikiAccessLevel),
            wiki_enabled: cdktf.booleanToTerraform(this._wikiEnabled),
            container_expiration_policy: projectContainerExpirationPolicyToTerraform(this._containerExpirationPolicy.internalValue),
            push_rules: projectPushRulesToTerraform(this._pushRules.internalValue),
        };
    }
}
exports.Project = Project;
_c = JSII_RTTI_SYMBOL_1;
Project[_c] = { fqn: "@cdktf/provider-gitlab.Project", version: "0.1.13" };
// =================
// STATIC PROPERTIES
// =================
Project.tfResourceType = "gitlab_project";
//# sourceMappingURL=data:application/json;base64,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