import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GroupShareGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Share expiration date. Format: `YYYY-MM-DD`
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group_share_group#expires_at GroupShareGroup#expires_at}
    */
    readonly expiresAt?: string;
    /**
    * The access level to grant the group. Valid values are: `no one`, `minimal`, `guest`, `reporter`, `developer`, `maintainer`, `owner`, `master`
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group_share_group#group_access GroupShareGroup#group_access}
    */
    readonly groupAccess: string;
    /**
    * The id of the main group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group_share_group#group_id GroupShareGroup#group_id}
    */
    readonly groupId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group_share_group#id GroupShareGroup#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The id of an additional group which will be shared with the main group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group_share_group#share_group_id GroupShareGroup#share_group_id}
    */
    readonly shareGroupId: number;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/group_share_group gitlab_group_share_group}
*/
export declare class GroupShareGroup extends cdktf.TerraformResource {
    static readonly tfResourceType = "gitlab_group_share_group";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/r/group_share_group gitlab_group_share_group} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GroupShareGroupConfig
    */
    constructor(scope: Construct, id: string, config: GroupShareGroupConfig);
    private _expiresAt?;
    get expiresAt(): string;
    set expiresAt(value: string);
    resetExpiresAt(): void;
    get expiresAtInput(): string | undefined;
    private _groupAccess?;
    get groupAccess(): string;
    set groupAccess(value: string);
    get groupAccessInput(): string | undefined;
    private _groupId?;
    get groupId(): string;
    set groupId(value: string);
    get groupIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _shareGroupId?;
    get shareGroupId(): number;
    set shareGroupId(value: number);
    get shareGroupIdInput(): number | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=group-share-group.d.ts.map