import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGitlabProjectConfig extends cdktf.TerraformMetaArguments {
    /**
    * The integer or path with namespace that uniquely identifies the project within the gitlab install.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/project#id DataGitlabProject#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The path of the repository with namespace.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/project#path_with_namespace DataGitlabProject#path_with_namespace}
    */
    readonly pathWithNamespace?: string;
    /**
    * If true, jobs can be viewed by non-project members.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/project#public_builds DataGitlabProject#public_builds}
    */
    readonly publicBuilds?: boolean | cdktf.IResolvable;
}
export interface DataGitlabProjectContainerExpirationPolicy {
}
export declare function dataGitlabProjectContainerExpirationPolicyToTerraform(struct?: DataGitlabProjectContainerExpirationPolicy): any;
export declare class DataGitlabProjectContainerExpirationPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGitlabProjectContainerExpirationPolicy | undefined;
    set internalValue(value: DataGitlabProjectContainerExpirationPolicy | undefined);
    get cadence(): string;
    get enabled(): cdktf.IResolvable;
    get keepN(): number;
    get nameRegexDelete(): string;
    get nameRegexKeep(): string;
    get nextRunAt(): string;
    get olderThan(): string;
}
export declare class DataGitlabProjectContainerExpirationPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGitlabProjectContainerExpirationPolicyOutputReference;
}
export interface DataGitlabProjectPushRules {
}
export declare function dataGitlabProjectPushRulesToTerraform(struct?: DataGitlabProjectPushRules): any;
export declare class DataGitlabProjectPushRulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGitlabProjectPushRules | undefined;
    set internalValue(value: DataGitlabProjectPushRules | undefined);
    get authorEmailRegex(): string;
    get branchNameRegex(): string;
    get commitCommitterCheck(): cdktf.IResolvable;
    get commitMessageNegativeRegex(): string;
    get commitMessageRegex(): string;
    get denyDeleteTag(): cdktf.IResolvable;
    get fileNameRegex(): string;
    get maxFileSize(): number;
    get memberCheck(): cdktf.IResolvable;
    get preventSecrets(): cdktf.IResolvable;
    get rejectUnsignedCommits(): cdktf.IResolvable;
}
export declare class DataGitlabProjectPushRulesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGitlabProjectPushRulesOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/d/project gitlab_project}
*/
export declare class DataGitlabProject extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "gitlab_project";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/d/project gitlab_project} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGitlabProjectConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataGitlabProjectConfig);
    get analyticsAccessLevel(): string;
    get archived(): cdktf.IResolvable;
    get autoCancelPendingPipelines(): string;
    get autoDevopsDeployStrategy(): string;
    get autoDevopsEnabled(): cdktf.IResolvable;
    get autocloseReferencedIssues(): cdktf.IResolvable;
    get buildGitStrategy(): string;
    get buildTimeout(): number;
    get buildsAccessLevel(): string;
    private _containerExpirationPolicy;
    get containerExpirationPolicy(): DataGitlabProjectContainerExpirationPolicyList;
    get containerRegistryAccessLevel(): string;
    get defaultBranch(): string;
    get description(): string;
    get emailsDisabled(): cdktf.IResolvable;
    get externalAuthorizationClassificationLabel(): string;
    get forkingAccessLevel(): string;
    get httpUrlToRepo(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get issuesAccessLevel(): string;
    get issuesEnabled(): cdktf.IResolvable;
    get lfsEnabled(): cdktf.IResolvable;
    get mergeCommitTemplate(): string;
    get mergePipelinesEnabled(): cdktf.IResolvable;
    get mergeRequestsAccessLevel(): string;
    get mergeRequestsEnabled(): cdktf.IResolvable;
    get mergeTrainsEnabled(): cdktf.IResolvable;
    get name(): string;
    get namespaceId(): number;
    get operationsAccessLevel(): string;
    get path(): string;
    private _pathWithNamespace?;
    get pathWithNamespace(): string;
    set pathWithNamespace(value: string);
    resetPathWithNamespace(): void;
    get pathWithNamespaceInput(): string | undefined;
    get pipelinesEnabled(): cdktf.IResolvable;
    get printingMergeRequestLinkEnabled(): cdktf.IResolvable;
    private _publicBuilds?;
    get publicBuilds(): boolean | cdktf.IResolvable;
    set publicBuilds(value: boolean | cdktf.IResolvable);
    resetPublicBuilds(): void;
    get publicBuildsInput(): boolean | cdktf.IResolvable | undefined;
    private _pushRules;
    get pushRules(): DataGitlabProjectPushRulesList;
    get removeSourceBranchAfterMerge(): cdktf.IResolvable;
    get repositoryAccessLevel(): string;
    get repositoryStorage(): string;
    get requestAccessEnabled(): cdktf.IResolvable;
    get requirementsAccessLevel(): string;
    get resolveOutdatedDiffDiscussions(): cdktf.IResolvable;
    get runnersToken(): string;
    get securityAndComplianceAccessLevel(): string;
    get snippetsAccessLevel(): string;
    get snippetsEnabled(): cdktf.IResolvable;
    get squashCommitTemplate(): string;
    get sshUrlToRepo(): string;
    get topics(): string[];
    get visibilityLevel(): string;
    get webUrl(): string;
    get wikiAccessLevel(): string;
    get wikiEnabled(): cdktf.IResolvable;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-gitlab-project.d.ts.map