import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGitlabProjectVariablesConfig extends cdktf.TerraformMetaArguments {
    /**
    * The environment scope of the variable. Defaults to all environment (`*`).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/project_variables#environment_scope DataGitlabProjectVariables#environment_scope}
    */
    readonly environmentScope?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/project_variables#id DataGitlabProjectVariables#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name or id of the project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/project_variables#project DataGitlabProjectVariables#project}
    */
    readonly project: string;
}
export interface DataGitlabProjectVariablesVariables {
}
export declare function dataGitlabProjectVariablesVariablesToTerraform(struct?: DataGitlabProjectVariablesVariables): any;
export declare class DataGitlabProjectVariablesVariablesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGitlabProjectVariablesVariables | undefined;
    set internalValue(value: DataGitlabProjectVariablesVariables | undefined);
    get environmentScope(): string;
    get key(): string;
    get masked(): cdktf.IResolvable;
    get project(): string;
    get protected(): cdktf.IResolvable;
    get value(): string;
    get variableType(): string;
}
export declare class DataGitlabProjectVariablesVariablesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGitlabProjectVariablesVariablesOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/d/project_variables gitlab_project_variables}
*/
export declare class DataGitlabProjectVariables extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "gitlab_project_variables";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/d/project_variables gitlab_project_variables} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGitlabProjectVariablesConfig
    */
    constructor(scope: Construct, id: string, config: DataGitlabProjectVariablesConfig);
    private _environmentScope?;
    get environmentScope(): string;
    set environmentScope(value: string);
    resetEnvironmentScope(): void;
    get environmentScopeInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
    private _variables;
    get variables(): DataGitlabProjectVariablesVariablesList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-gitlab-project-variables.d.ts.map