import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGitlabProjectVariableConfig extends cdktf.TerraformMetaArguments {
    /**
    * The environment scope of the variable. Defaults to all environment (`*`). Note that in Community Editions of Gitlab, values other than `*` will cause inconsistent plans.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/project_variable#environment_scope DataGitlabProjectVariable#environment_scope}
    */
    readonly environmentScope?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/project_variable#id DataGitlabProjectVariable#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the variable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/project_variable#key DataGitlabProjectVariable#key}
    */
    readonly key: string;
    /**
    * The name or id of the project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/project_variable#project DataGitlabProjectVariable#project}
    */
    readonly project: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/d/project_variable gitlab_project_variable}
*/
export declare class DataGitlabProjectVariable extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "gitlab_project_variable";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/d/project_variable gitlab_project_variable} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGitlabProjectVariableConfig
    */
    constructor(scope: Construct, id: string, config: DataGitlabProjectVariableConfig);
    private _environmentScope?;
    get environmentScope(): string;
    set environmentScope(value: string);
    resetEnvironmentScope(): void;
    get environmentScopeInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    get masked(): cdktf.IResolvable;
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
    get protected(): cdktf.IResolvable;
    get value(): string;
    get variableType(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-gitlab-project-variable.d.ts.map