# coding: utf-8

"""
    Kiln API Specifications

    This API provides reporting staking data on various protocols as well as network wide data, staking transaction crafting features and so on. In order to use it, you should first get an API token from your Kiln dashboard (applications section). If you don't have access to our dashboard, please get in touch at hello@kiln.fi. Once you have your API token, you can set it as a bearer token in your request headers.  ### Backward Compatibility  This is an experimental specification used for development and testing, do not rely on what is here unless you know the implications.  The official Kiln API specification following backward compatible changes can be found [here](/).  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: contact@kiln.fi
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional
from pydantic import BaseModel, Field, StrictInt, StrictStr

class TezosStake(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    stake_address: Optional[StrictStr] = Field(None, description="Wallet address of the delegator")
    baker_address: Optional[StrictStr] = Field(None, description="Address of the baker")
    state: Optional[StrictStr] = Field(None, description="State of the Tezos stake")
    activated_at: Optional[datetime] = Field(None, description="Date at which the stake started earning rewards")
    activated_cycle: Optional[StrictInt] = Field(None, description="Cycle at which the stake started earning rewards")
    delegated_at: Optional[datetime] = Field(None, description="Cycle in which the delegation transaction was made")
    delegated_cycle: Optional[StrictInt] = Field(None, description="Date at which the staking transaction was made, corresponds to the block it was part of.")
    delegated_block: Optional[StrictStr] = Field(None, description="Block at which the corresponding staking transaction was executed")
    balance: Optional[StrictStr] = Field(None, description="Current balance in mutez")
    rewards: Optional[StrictStr] = Field(None, description="Sum of rewards in mutez earned by this stake since delegation")
    gross_apy: Optional[float] = Field(None, description="Gross annual percentage yield")
    updated_at: Optional[datetime] = Field(None, description="Last date this data was updated")
    __properties = ["stake_address", "baker_address", "state", "activated_at", "activated_cycle", "delegated_at", "delegated_cycle", "delegated_block", "balance", "rewards", "gross_apy", "updated_at"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TezosStake:
        """Create an instance of TezosStake from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if activated_at (nullable) is None
        if self.activated_at is None:
            _dict['activated_at'] = None

        # set to None if activated_cycle (nullable) is None
        if self.activated_cycle is None:
            _dict['activated_cycle'] = None

        # set to None if delegated_at (nullable) is None
        if self.delegated_at is None:
            _dict['delegated_at'] = None

        # set to None if delegated_cycle (nullable) is None
        if self.delegated_cycle is None:
            _dict['delegated_cycle'] = None

        # set to None if delegated_block (nullable) is None
        if self.delegated_block is None:
            _dict['delegated_block'] = None

        # set to None if balance (nullable) is None
        if self.balance is None:
            _dict['balance'] = None

        # set to None if rewards (nullable) is None
        if self.rewards is None:
            _dict['rewards'] = None

        # set to None if gross_apy (nullable) is None
        if self.gross_apy is None:
            _dict['gross_apy'] = None

        # set to None if updated_at (nullable) is None
        if self.updated_at is None:
            _dict['updated_at'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TezosStake:
        """Create an instance of TezosStake from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return TezosStake.parse_obj(obj)

        _obj = TezosStake.parse_obj({
            "stake_address": obj.get("stake_address"),
            "baker_address": obj.get("baker_address"),
            "state": obj.get("state"),
            "activated_at": obj.get("activated_at"),
            "activated_cycle": obj.get("activated_cycle"),
            "delegated_at": obj.get("delegated_at"),
            "delegated_cycle": obj.get("delegated_cycle"),
            "delegated_block": obj.get("delegated_block"),
            "balance": obj.get("balance"),
            "rewards": obj.get("rewards"),
            "gross_apy": obj.get("gross_apy"),
            "updated_at": obj.get("updated_at")
        })
        return _obj

