# coding: utf-8

"""
    Kiln API Specifications

    This API provides reporting staking data on various protocols as well as network wide data, staking transaction crafting features and so on. In order to use it, you should first get an API token from your Kiln dashboard (applications section). If you don't have access to our dashboard, please get in touch at hello@kiln.fi. Once you have your API token, you can set it as a bearer token in your request headers.  ### Backward Compatibility  This is an experimental specification used for development and testing, do not rely on what is here unless you know the implications.  The official Kiln API specification following backward compatible changes can be found [here](/).  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: contact@kiln.fi
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import json
import re  # noqa: F401

from typing import Any, List, Optional
from pydantic import BaseModel, Field, StrictStr, ValidationError, validator
from kiln_connect.openapi_client.models.ethereum_operation_consensus_withdrawal import EthereumOperationConsensusWithdrawal
from kiln_connect.openapi_client.models.ethereum_operation_deposit import EthereumOperationDeposit
from kiln_connect.openapi_client.models.ethereum_operation_execution_reward import EthereumOperationExecutionReward
from typing import Any, List
from pydantic import StrictStr, Field

GETETHOPERATIONS200RESPONSEDATAINNER_ONE_OF_SCHEMAS = ["EthereumOperationConsensusWithdrawal", "EthereumOperationDeposit", "EthereumOperationExecutionReward"]

class GetEthOperations200ResponseDataInner(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    # data type: EthereumOperationDeposit
    oneof_schema_1_validator: Optional[EthereumOperationDeposit] = None
    # data type: EthereumOperationConsensusWithdrawal
    oneof_schema_2_validator: Optional[EthereumOperationConsensusWithdrawal] = None
    # data type: EthereumOperationExecutionReward
    oneof_schema_3_validator: Optional[EthereumOperationExecutionReward] = None
    actual_instance: Any
    one_of_schemas: List[str] = Field(GETETHOPERATIONS200RESPONSEDATAINNER_ONE_OF_SCHEMAS, const=True)

    class Config:
        validate_assignment = True

    discriminator_value_class_map = {
    }

    @validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        error_messages = []
        match = 0
        # validate data type: EthereumOperationDeposit
        if type(v) is not EthereumOperationDeposit:
            error_messages.append(f"Error! Input type `{type(v)}` is not `EthereumOperationDeposit`")
        else:
            match += 1

        # validate data type: EthereumOperationConsensusWithdrawal
        if type(v) is not EthereumOperationConsensusWithdrawal:
            error_messages.append(f"Error! Input type `{type(v)}` is not `EthereumOperationConsensusWithdrawal`")
        else:
            match += 1

        # validate data type: EthereumOperationExecutionReward
        if type(v) is not EthereumOperationExecutionReward:
            error_messages.append(f"Error! Input type `{type(v)}` is not `EthereumOperationExecutionReward`")
        else:
            match += 1

        if match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into GetEthOperations200ResponseDataInner with oneOf schemas: EthereumOperationConsensusWithdrawal, EthereumOperationDeposit, EthereumOperationExecutionReward. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: dict) -> GetEthOperations200ResponseDataInner:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> GetEthOperations200ResponseDataInner:
        """Returns the object represented by the json string"""
        instance = cls()
        error_messages = []
        match = 0

        # deserialize data into EthereumOperationDeposit
        try:
            instance.actual_instance = EthereumOperationDeposit.from_json(json_str)
            match += 1
        except ValidationError as e:
            error_messages.append(str(e))
        # deserialize data into EthereumOperationConsensusWithdrawal
        try:
            instance.actual_instance = EthereumOperationConsensusWithdrawal.from_json(json_str)
            match += 1
        except ValidationError as e:
            error_messages.append(str(e))
        # deserialize data into EthereumOperationExecutionReward
        try:
            instance.actual_instance = EthereumOperationExecutionReward.from_json(json_str)
            match += 1
        except ValidationError as e:
            error_messages.append(str(e))

        if match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into GetEthOperations200ResponseDataInner with oneOf schemas: EthereumOperationConsensusWithdrawal, EthereumOperationDeposit, EthereumOperationExecutionReward. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is not None:
            return self.actual_instance.to_json()
        else:
            return "null"

    def to_dict(self) -> dict:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is not None:
            return self.actual_instance.to_dict()
        else:
            return dict()

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.dict())





