# coding: utf-8

"""
    Kiln API Specifications

    This API provides reporting staking data on various protocols as well as network wide data, staking transaction crafting features and so on. In order to use it, you should first get an API token from your Kiln dashboard (applications section). If you don't have access to our dashboard, please get in touch at hello@kiln.fi. Once you have your API token, you can set it as a bearer token in your request headers.  ### Backward Compatibility  This is an experimental specification used for development and testing, do not rely on what is here unless you know the implications.  The official Kiln API specification following backward compatible changes can be found [here](/).  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: contact@kiln.fi
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from datetime import date

from pydantic import Field, StrictStr, conlist

from typing import Optional

from kiln_connect.openapi_client.models.get_xtz_network_stats200_response import GetXtzNetworkStats200Response
from kiln_connect.openapi_client.models.get_xtz_rewards200_response import GetXtzRewards200Response
from kiln_connect.openapi_client.models.get_xtz_stakes200_response import GetXtzStakes200Response

from kiln_connect.openapi_client.api_client import ApiClient
from kiln_connect.openapi_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class XtzApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def get_xtz_network_stats(self, **kwargs) -> GetXtzNetworkStats200Response:  # noqa: E501
        """Network Stats  # noqa: E501

        Get some network statistics on Tezos staking  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_xtz_network_stats(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetXtzNetworkStats200Response
        """
        kwargs['_return_http_data_only'] = True
        return self.get_xtz_network_stats_with_http_info(**kwargs)  # noqa: E501

    @validate_arguments
    def get_xtz_network_stats_with_http_info(self, **kwargs):  # noqa: E501
        """Network Stats  # noqa: E501

        Get some network statistics on Tezos staking  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_xtz_network_stats_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetXtzNetworkStats200Response, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_xtz_network_stats" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json; charset=utf-8'])  # noqa: E501

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "GetXtzNetworkStats200Response",
            '401': None,
            '500': None,
        }

        return self.api_client.call_api(
            '/v1/xtz/network-stats', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_xtz_rewards(self, wallets : Annotated[Optional[conlist(StrictStr)], Field(description="Comma-separated list of wallets addresses")] = None, accounts : Annotated[Optional[conlist(StrictStr)], Field(description="Comma-separated list of Kiln accounts identifiers")] = None, format : Annotated[Optional[StrictStr], Field(description="The format of the response. Defaults to daily")] = None, start_date : Annotated[Optional[date], Field(description="Get rewards from this date (YYYY-MM-DD)")] = None, end_date : Annotated[Optional[date], Field(description="Get rewards to this date (YYYY-MM-DD)")] = None, start_cycle : Annotated[Optional[float], Field(description="The cycle from which we want to fetch rewards. Must be used with format=cycle")] = None, end_cycle : Annotated[Optional[float], Field(description="The cycle until which we want to fetch rewards. Must be used with format=cycle")] = None, **kwargs) -> GetXtzRewards200Response:  # noqa: E501
        """Rewards  # noqa: E501

        Get historical rewards of Tezos stakes  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_xtz_rewards(wallets, accounts, format, start_date, end_date, start_cycle, end_cycle, async_req=True)
        >>> result = thread.get()

        :param wallets: Comma-separated list of wallets addresses
        :type wallets: List[str]
        :param accounts: Comma-separated list of Kiln accounts identifiers
        :type accounts: List[str]
        :param format: The format of the response. Defaults to daily
        :type format: str
        :param start_date: Get rewards from this date (YYYY-MM-DD)
        :type start_date: date
        :param end_date: Get rewards to this date (YYYY-MM-DD)
        :type end_date: date
        :param start_cycle: The cycle from which we want to fetch rewards. Must be used with format=cycle
        :type start_cycle: float
        :param end_cycle: The cycle until which we want to fetch rewards. Must be used with format=cycle
        :type end_cycle: float
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetXtzRewards200Response
        """
        kwargs['_return_http_data_only'] = True
        return self.get_xtz_rewards_with_http_info(wallets, accounts, format, start_date, end_date, start_cycle, end_cycle, **kwargs)  # noqa: E501

    @validate_arguments
    def get_xtz_rewards_with_http_info(self, wallets : Annotated[Optional[conlist(StrictStr)], Field(description="Comma-separated list of wallets addresses")] = None, accounts : Annotated[Optional[conlist(StrictStr)], Field(description="Comma-separated list of Kiln accounts identifiers")] = None, format : Annotated[Optional[StrictStr], Field(description="The format of the response. Defaults to daily")] = None, start_date : Annotated[Optional[date], Field(description="Get rewards from this date (YYYY-MM-DD)")] = None, end_date : Annotated[Optional[date], Field(description="Get rewards to this date (YYYY-MM-DD)")] = None, start_cycle : Annotated[Optional[float], Field(description="The cycle from which we want to fetch rewards. Must be used with format=cycle")] = None, end_cycle : Annotated[Optional[float], Field(description="The cycle until which we want to fetch rewards. Must be used with format=cycle")] = None, **kwargs):  # noqa: E501
        """Rewards  # noqa: E501

        Get historical rewards of Tezos stakes  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_xtz_rewards_with_http_info(wallets, accounts, format, start_date, end_date, start_cycle, end_cycle, async_req=True)
        >>> result = thread.get()

        :param wallets: Comma-separated list of wallets addresses
        :type wallets: List[str]
        :param accounts: Comma-separated list of Kiln accounts identifiers
        :type accounts: List[str]
        :param format: The format of the response. Defaults to daily
        :type format: str
        :param start_date: Get rewards from this date (YYYY-MM-DD)
        :type start_date: date
        :param end_date: Get rewards to this date (YYYY-MM-DD)
        :type end_date: date
        :param start_cycle: The cycle from which we want to fetch rewards. Must be used with format=cycle
        :type start_cycle: float
        :param end_cycle: The cycle until which we want to fetch rewards. Must be used with format=cycle
        :type end_cycle: float
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetXtzRewards200Response, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'wallets',
            'accounts',
            'format',
            'start_date',
            'end_date',
            'start_cycle',
            'end_cycle'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_xtz_rewards" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('wallets') is not None:  # noqa: E501
            _query_params.append(('wallets', _params['wallets']))
            _collection_formats['wallets'] = 'csv'
        if _params.get('accounts') is not None:  # noqa: E501
            _query_params.append(('accounts', _params['accounts']))
            _collection_formats['accounts'] = 'csv'
        if _params.get('format') is not None:  # noqa: E501
            _query_params.append(('format', _params['format']))
        if _params.get('start_date') is not None:  # noqa: E501
            _query_params.append(('start_date', _params['start_date']))
        if _params.get('end_date') is not None:  # noqa: E501
            _query_params.append(('end_date', _params['end_date']))
        if _params.get('start_cycle') is not None:  # noqa: E501
            _query_params.append(('start_cycle', _params['start_cycle']))
        if _params.get('end_cycle') is not None:  # noqa: E501
            _query_params.append(('end_cycle', _params['end_cycle']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json; charset=utf-8'])  # noqa: E501

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "GetXtzRewards200Response",
            '400': None,
            '401': None,
            '500': None,
        }

        return self.api_client.call_api(
            '/v1/xtz/rewards', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_xtz_stakes(self, wallets : Annotated[Optional[conlist(StrictStr)], Field(description="Comma-separated list of wallets addresses")] = None, accounts : Annotated[Optional[conlist(StrictStr)], Field(description="Comma-separated list of Kiln accounts identifiers")] = None, **kwargs) -> GetXtzStakes200Response:  # noqa: E501
        """Stakes  # noqa: E501

        Get the status of Tezos stakes  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_xtz_stakes(wallets, accounts, async_req=True)
        >>> result = thread.get()

        :param wallets: Comma-separated list of wallets addresses
        :type wallets: List[str]
        :param accounts: Comma-separated list of Kiln accounts identifiers
        :type accounts: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetXtzStakes200Response
        """
        kwargs['_return_http_data_only'] = True
        return self.get_xtz_stakes_with_http_info(wallets, accounts, **kwargs)  # noqa: E501

    @validate_arguments
    def get_xtz_stakes_with_http_info(self, wallets : Annotated[Optional[conlist(StrictStr)], Field(description="Comma-separated list of wallets addresses")] = None, accounts : Annotated[Optional[conlist(StrictStr)], Field(description="Comma-separated list of Kiln accounts identifiers")] = None, **kwargs):  # noqa: E501
        """Stakes  # noqa: E501

        Get the status of Tezos stakes  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_xtz_stakes_with_http_info(wallets, accounts, async_req=True)
        >>> result = thread.get()

        :param wallets: Comma-separated list of wallets addresses
        :type wallets: List[str]
        :param accounts: Comma-separated list of Kiln accounts identifiers
        :type accounts: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetXtzStakes200Response, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'wallets',
            'accounts'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_xtz_stakes" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('wallets') is not None:  # noqa: E501
            _query_params.append(('wallets', _params['wallets']))
            _collection_formats['wallets'] = 'csv'
        if _params.get('accounts') is not None:  # noqa: E501
            _query_params.append(('accounts', _params['accounts']))
            _collection_formats['accounts'] = 'csv'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json; charset=utf-8'])  # noqa: E501

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "GetXtzStakes200Response",
            '400': None,
            '401': None,
            '500': None,
        }

        return self.api_client.call_api(
            '/v1/xtz/stakes', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
