# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['kyoslib_py']

package_data = \
{'': ['*']}

install_requires = \
['h5py>=3.6.0,<4.0.0',
 'numba==0.56.4',
 'numpy<1.22.1',
 'pandas<1.5.3',
 'plotly>=5.7.0,<6.0.0',
 'requests>=2.28.1,<3.0.0']

entry_points = \
{'console_scripts': ['run_model = src.entry:main']}

setup_kwargs = {
    'name': 'kyoslib-py',
    'version': '4.0.2',
    'description': 'KYOS shared lib code as python package',
    'long_description': "# kyoslib_py\n\n## Usage\n\nExample code:\n\n```python\nfrom kyoslib_py.simulation import Simulation\nsimulation_set = Simulation()\n```\n\n## Installation\n\n```pip install kyoslib_py -extra-index-url https://pypi.fury.io/kyos/```\n\n## Dependencies\n\nPython 3.7+\n\n## Development\n\nThis project is executing CI checks using **GitHub actions**.\n\nIt will run `pytest` and `black`.\n\n### Invoking development tasks\n\n[Invoke](https://www.pyinvoke.org/) is used for development tasks.\n\nTasks are stored in `tasks.py` and are executable using the `inv[oke]` command line tool.\n\nTo see the list of tasks, you can type:\n\n```bash\ninv --list\n```\n\nFor example, before your commits, you should run\n```bash\ninv format\n```\nto format your code.\n\n## Documentation\n\nThe package documentation is generated by MkDocs. The correct version can be installed in the project's virtual environment by:\n\n```bash\npoetry install\n```\n\nThen the documentation can be built, and a server to view it started by:\n\n```bash\nmkdocs serve\n```\n",
    'author': 'KYOS',
    'author_email': 'support@kyos.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'http://github.com/kyosenergy/kyoslib_py',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<3.10',
}


setup(**setup_kwargs)
