# kyoslib_py

## Usage

Example code:

```python
from kyoslib_py.simulation import Simulation
simulation_set = Simulation()
```

## Installation

```pip install kyoslib_py -extra-index-url https://pypi.fury.io/kyos/```

## Dependencies

Python 3.7+

## Development

This project is executing CI checks using **GitHub actions**.

It will run `pytest` and `black`.

### Invoking development tasks

[Invoke](https://www.pyinvoke.org/) is used for development tasks.

Tasks are stored in `tasks.py` and are executable using the `inv[oke]` command line tool.

To see the list of tasks, you can type:

```bash
inv --list
```

For example, before your commits, you should run
```bash
inv format
```
to format your code.

## Documentation

The package documentation is generated by MkDocs. The correct version can be installed in the project's virtual environment by:

```bash
poetry install
```

Then the documentation can be built, and a server to view it started by:

```bash
mkdocs serve
```
