"""Separate gateways from compute

Revision ID: e6391ca6a264
Revises: 686fb8341ea5
Create Date: 2023-12-11 10:34:28.112500

"""

import sqlalchemy as sa
import sqlalchemy_utils
from alembic import op

# revision identifiers, used by Alembic.
revision = "e6391ca6a264"
down_revision = "686fb8341ea5"
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "gateway_computes",
        sa.Column("id", sqlalchemy_utils.types.uuid.UUIDType(binary=False), nullable=False),
        sa.Column("created_at", sa.DateTime(), nullable=False),
        sa.Column("instance_id", sa.String(length=100), nullable=False),
        sa.Column("ip_address", sa.String(length=100), nullable=False),
        sa.Column("region", sa.String(length=100), nullable=False),
        sa.Column("backend_id", sqlalchemy_utils.types.uuid.UUIDType(binary=False), nullable=True),
        sa.Column("ssh_private_key", sa.Text(), nullable=False),
        sa.Column("ssh_public_key", sa.Text(), nullable=False),
        sa.ForeignKeyConstraint(
            ["backend_id"],
            ["backends.id"],
            name=op.f("fk_gateway_computes_backend_id_backends"),
            ondelete="CASCADE",
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_gateway_computes")),
    )
    with op.batch_alter_table("gateways", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column(
                "gateway_compute_id",
                sqlalchemy_utils.types.uuid.UUIDType(binary=False),
                nullable=True,
            )
        )
        batch_op.create_foreign_key(
            batch_op.f("fk_gateways_gateway_compute_id_gateway_computes"),
            "gateway_computes",
            ["gateway_compute_id"],
            ["id"],
            ondelete="CASCADE",
        )
        batch_op.drop_column("ip_address")
        batch_op.drop_column("instance_id")

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("gateways", schema=None) as batch_op:
        batch_op.add_column(sa.Column("instance_id", sa.VARCHAR(length=100), nullable=False))
        batch_op.add_column(sa.Column("ip_address", sa.VARCHAR(length=100), nullable=False))
        batch_op.drop_constraint(
            batch_op.f("fk_gateways_gateway_compute_id_gateway_computes"), type_="foreignkey"
        )
        batch_op.drop_column("gateway_compute_id")

    op.drop_table("gateway_computes")
    # ### end Alembic commands ###
