"""Support fleets

Revision ID: c00090eaef21
Revises: 3cf77fb8bcf1
Create Date: 2024-07-17 15:43:24.476764

"""

import sqlalchemy as sa
import sqlalchemy_utils
from alembic import op
from sqlalchemy.dialects import postgresql

import dstack._internal.server.models

# revision identifiers, used by Alembic.
revision = "c00090eaef21"
down_revision = "3cf77fb8bcf1"
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    sa.Enum(
        "SUBMITTED", "ACTIVE", "TERMINATING", "TERMINATED", "FAILED", name="fleetstatus"
    ).create(op.get_bind())
    op.create_table(
        "fleets",
        sa.Column("id", sqlalchemy_utils.types.uuid.UUIDType(binary=False), nullable=False),
        sa.Column("name", sa.String(length=100), nullable=False),
        sa.Column(
            "project_id", sqlalchemy_utils.types.uuid.UUIDType(binary=False), nullable=False
        ),
        sa.Column("created_at", dstack._internal.server.models.NaiveDateTime(), nullable=False),
        sa.Column(
            "last_processed_at", dstack._internal.server.models.NaiveDateTime(), nullable=False
        ),
        sa.Column("deleted", sa.Boolean(), nullable=False),
        sa.Column("deleted_at", dstack._internal.server.models.NaiveDateTime(), nullable=True),
        sa.Column(
            "status",
            postgresql.ENUM(
                "SUBMITTED",
                "ACTIVE",
                "TERMINATING",
                "TERMINATED",
                "FAILED",
                name="fleetstatus",
                create_type=False,
            ),
            nullable=False,
        ),
        sa.Column("status_message", sa.Text(), nullable=True),
        sa.Column("spec", sa.Text(), nullable=False),
        sa.ForeignKeyConstraint(
            ["project_id"],
            ["projects.id"],
            name=op.f("fk_fleets_project_id_projects"),
            ondelete="CASCADE",
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_fleets")),
    )
    with op.batch_alter_table("instances", schema=None) as batch_op:
        batch_op.add_column(sa.Column("instance_num", sa.Integer(), nullable=True))
        batch_op.add_column(
            sa.Column(
                "fleet_id", sqlalchemy_utils.types.uuid.UUIDType(binary=False), nullable=True
            )
        )
        batch_op.create_foreign_key(
            batch_op.f("fk_instances_fleet_id_fleets"), "fleets", ["fleet_id"], ["id"]
        )

    batch_op.execute("UPDATE instances SET instance_num = 0")

    with op.batch_alter_table("instances", schema=None) as batch_op:
        batch_op.alter_column("instance_num", nullable=False)

    with op.batch_alter_table("runs", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column(
                "fleet_id", sqlalchemy_utils.types.uuid.UUIDType(binary=False), nullable=True
            )
        )
        batch_op.create_foreign_key(
            batch_op.f("fk_runs_fleet_id_fleets"), "fleets", ["fleet_id"], ["id"]
        )

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("runs", schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f("fk_runs_fleet_id_fleets"), type_="foreignkey")
        batch_op.drop_column("fleet_id")

    with op.batch_alter_table("instances", schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f("fk_instances_fleet_id_fleets"), type_="foreignkey")
        batch_op.drop_column("fleet_id")
        batch_op.drop_column("instance_num")

    op.drop_table("fleets")
    sa.Enum("SUBMITTED", "ACTIVE", "TERMINATING", "TERMINATED", "FAILED", name="fleetstatus").drop(
        op.get_bind()
    )
    # ### end Alembic commands ###
