"""Add PlacementGroupModel

Revision ID: a7b46c073fa1
Revises: e3b7db07727f
Create Date: 2024-09-25 13:52:28.701586

"""

import sqlalchemy as sa
import sqlalchemy_utils
from alembic import op

import dstack._internal.server.models

# revision identifiers, used by Alembic.
revision = "a7b46c073fa1"
down_revision = "e3b7db07727f"
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "placement_groups",
        sa.Column("id", sqlalchemy_utils.types.uuid.UUIDType(binary=False), nullable=False),
        sa.Column("name", sa.String(length=100), nullable=False),
        sa.Column(
            "project_id", sqlalchemy_utils.types.uuid.UUIDType(binary=False), nullable=False
        ),
        sa.Column("fleet_id", sqlalchemy_utils.types.uuid.UUIDType(binary=False), nullable=False),
        sa.Column("fleet_deleted", sa.Boolean(), nullable=False),
        sa.Column("created_at", dstack._internal.server.models.NaiveDateTime(), nullable=False),
        sa.Column(
            "last_processed_at", dstack._internal.server.models.NaiveDateTime(), nullable=False
        ),
        sa.Column("deleted", sa.Boolean(), nullable=False),
        sa.Column("deleted_at", dstack._internal.server.models.NaiveDateTime(), nullable=True),
        sa.Column("configuration", sa.Text(), nullable=False),
        sa.Column("provisioning_data", sa.Text(), nullable=True),
        sa.ForeignKeyConstraint(
            ["fleet_id"], ["fleets.id"], name=op.f("fk_placement_groups_fleet_id_fleets")
        ),
        sa.ForeignKeyConstraint(
            ["project_id"],
            ["projects.id"],
            name=op.f("fk_placement_groups_project_id_projects"),
            ondelete="CASCADE",
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_placement_groups")),
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("placement_groups")
    # ### end Alembic commands ###
