"""Add termination_reason_message

Revision ID: 99b4c8c954ea
Revises: 5ec538b70e71
Create Date: 2024-03-29 06:37:53.702536

"""

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "99b4c8c954ea"
down_revision = "5ec538b70e71"
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("jobs", schema=None) as batch_op:
        batch_op.add_column(sa.Column("termination_reason_message", sa.Text(), nullable=True))
        batch_op.alter_column(
            "termination_reason",
            existing_type=sa.VARCHAR(length=34),
            type_=sa.Enum(
                "FAILED_TO_START_DUE_TO_NO_CAPACITY",
                "INTERRUPTED_BY_NO_CAPACITY",
                "WAITING_RUNNER_LIMIT_EXCEEDED",
                "TERMINATED_BY_USER",
                "GATEWAY_ERROR",
                "SCALED_DOWN",
                "DONE_BY_RUNNER",
                "ABORTED_BY_USER",
                "TERMINATED_BY_SERVER",
                "CONTAINER_EXITED_WITH_ERROR",
                "PORTS_BINDING_FAILED",
                "CREATING_CONTAINER_ERROR",
                "EXECUTOR_ERROR",
                name="jobterminationreason",
            ),
            existing_nullable=False,
        )

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("jobs", schema=None) as batch_op:
        batch_op.drop_column("termination_reason_message")
        batch_op.alter_column(
            "termination_reason",
            type_=sa.Enum(
                "FAILED_TO_START_DUE_TO_NO_CAPACITY",
                "INTERRUPTED_BY_NO_CAPACITY",
                "WAITING_RUNNER_LIMIT_EXCEEDED",
                "TERMINATED_BY_USER",
                "GATEWAY_ERROR",
                "SCALED_DOWN",
                "DONE_BY_RUNNER",
                "ABORTED_BY_USER",
                "TERMINATED_BY_SERVER",
                "CONTAINER_EXITED_WITH_ERROR",
                "PORTS_BINDING_FAILED",
                name="jobterminationreason",
            ),
            existing_nullable=False,
        )

    # ### end Alembic commands ###
