"""empty message

Revision ID: 82b32a135ea2
Revises: afbc600ff2b2
Create Date: 2024-11-04 15:46:37.719531

"""

import sqlalchemy as sa
import sqlalchemy_utils
from alembic import op

# revision identifiers, used by Alembic.
revision = "82b32a135ea2"
down_revision = "afbc600ff2b2"
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("volumes", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column("user_id", sqlalchemy_utils.types.uuid.UUIDType(binary=False), nullable=True)
        )
        batch_op.create_foreign_key(
            batch_op.f("fk_volumes_user_id_users"),
            "users",
            ["user_id"],
            ["id"],
            ondelete="CASCADE",
        )

    # ### end Alembic commands ###

    # update any existing volumes and set the user_id equal to the project_owner.id which created the volume
    op.execute("""
        UPDATE volumes AS v
        SET user_id = (
            SELECT owner_id FROM projects
            JOIN volumes ON projects.id = volumes.project_id
            WHERE volumes.id = v.id
        )
        WHERE user_id IS NULL
    """)

    # set volumes.user_id to non-nullable
    with op.batch_alter_table("volumes", schema=None) as batch_op:
        batch_op.alter_column("user_id", nullable=False)


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("volumes", schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f("fk_volumes_user_id_users"), type_="foreignkey")
        batch_op.drop_column("user_id")

    # ### end Alembic commands ###
