"""Add Manager project role

Revision ID: 54a77e19c64c
Revises: 710e5b3fac8f
Create Date: 2024-08-16 14:25:52.125915

"""

import sqlalchemy as sa
from alembic import op
from alembic_postgresql_enum import TableReference

# revision identifiers, used by Alembic.
revision = "54a77e19c64c"
down_revision = "710e5b3fac8f"
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    if op.get_context().dialect.name == "postgresql":
        op.sync_enum_values(
            "public",
            "projectrole",
            ["ADMIN", "MANAGER", "USER"],
            [
                TableReference(
                    table_schema="public", table_name="members", column_name="project_role"
                )
            ],
            enum_values_to_rename=[],
        )
    else:
        with op.batch_alter_table("members", schema=None) as batch_op:
            batch_op.alter_column(
                "project_role",
                existing_type=sa.VARCHAR(length=5),
                type_=sa.Enum("ADMIN", "MANAGER", "USER", name="projectrole"),
                existing_nullable=False,
            )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    if op.get_context().dialect.name == "postgresql":
        op.sync_enum_values(
            "public",
            "projectrole",
            ["ADMIN", "USER"],
            [
                TableReference(
                    table_schema="public", table_name="members", column_name="project_role"
                )
            ],
            enum_values_to_rename=[],
        )
    else:
        with op.batch_alter_table("members", schema=None) as batch_op:
            batch_op.alter_column(
                "project_role",
                existing_type=sa.Enum("ADMIN", "MANAGER", "USER", name="projectrole"),
                type_=sa.VARCHAR(length=5),
                existing_nullable=False,
            )
    # ### end Alembic commands ###
