# Generated by Django 2.2.28 on 2022-07-20 13:27

from django.db import migrations
from pagemeta.models import MetaForPage

from ._utils import copy_file_to_storage

def migrate_pagemeta_data(apps, schema_editor):
    '''
    Migrates meta data for pages (home page and blog list).
    '''

    print('\n  Migrating page meta data...')
    MetaForPage.objects.create(
        page_url='DEFAULT', # or default
        title='Welcome to my blog website',
        description='Welcome to my blog website. Get the latest news and blogs about the world.',
        image=copy_file_to_storage('pagemeta_example/static/images/blog.jpg'),
        keywords='blog, website, news, blog and news, latest news, latest, blog',
    )
    MetaForPage.objects.create(
        page_url='/blogs/',
        title='Blog list page',
        description='Blog list page. Get the latest news and blogs about the world.',
        image=copy_file_to_storage('pagemeta_example/static/images/blog.jpg'),
    )
    print('  Page meta data migrated.')

class Migration(migrations.Migration):
    dependencies = [
        ('pagemeta', '0001_initial'),
        ('pagemeta_example', '0002_blog_data'),
    ]

    operations = [
        migrations.RunPython(migrate_pagemeta_data),
    ]
