from __future__ import annotations
from enum import Enum

__NAMESPACE__ = "http://www.energistics.org/energyml/data/witsmlv2"


class TubularComponentType(Enum):
    """Specifies the types of components that can be used in a tubular string.

    These are used to specify the type of component and multiple
    components are used to define a tubular string (Tubular).
    """
    ACCELERATOR = "accelerator"
    ADJUSTABLE_KICKOFF = "adjustable kickoff"
    BIT_CORE_DIAMOND = "bit core diamond"
    BIT_CORE_PDC = "bit core PDC"
    BIT_DIAMOND_FIXED_CUT = "bit diamond fixed cut"
    BIT_HOLE_OPENER = "bit hole opener"
    BIT_INSERT_ROLLER_CONE = "bit insert roller cone"
    BIT_MILL_TOOTH_ROLLER_CONE = "bit mill tooth roller cone"
    BIT_PDC_FIXED_CUTTER = "bit PDC fixed cutter"
    BIT_UNDER_REAMER = "bit under reamer"
    BRIDGE_PLUG = "bridge plug"
    BULL_PLUG = "bull plug"
    BULLNOSE = "bullnose"
    CASING = "casing"
    CASING_CROSSOVER = "casing crossover"
    CASING_CUTTER = "casing cutter"
    CASING_HEAD = "casing head"
    CASING_INFLATABLE_PACKER = "casing inflatable packer"
    CASING_SHOE_SCREW_IN = "casing shoe screw-in"
    CATCH_ASSEMBLY = "catch assembly"
    COILED_TUBING_IN_HOLE = "coiled tubing in hole"
    COILED_TUBING_ON_COIL = "coiled tubing on coil"
    CORE_BARREL = "core barrel"
    CORE_ORIENTATION_BARREL = "core orientation barrel"
    DIE_COLLAR = "die collar"
    DIE_COLLAR_LH = "die collar LH"
    DIRECTIONAL_GUIDANCE_SYSTEM = "directional guidance system"
    DRILL_COLLAR = "drill collar"
    DRILL_COLLAR_SHORT = "drill collar short"
    DRILL_PIPE = "drill pipe"
    DRILL_PIPE_COMPRESSIVE = "drill pipe compressive"
    DRILL_PIPE_LH = "drill pipe LH"
    DRILL_STEM_TEST_BHA = "drill stem test BHA"
    DRIVE_PIPE = "drive pipe"
    DUAL_CATCH_ASSEMBLY = "dual catch assembly"
    EXTENSION_BOWL_OVERSHOT = "extension bowl overshot"
    EXTENSION_SUB_OVERSHOT = "extension sub-overshot"
    FLOAT_COLLAR = "float collar"
    FLOAT_SHOE = "float shoe"
    FLOW_HEAD = "flow head"
    GUIDE_SHOE = "guide shoe"
    HANGER_CASING_SUBSEA = "hanger casing subsea"
    HANGER_CASING_SURFACE = "hanger casing surface"
    HANGER_LINER = "hanger liner"
    HANGER_MUD_LINE = "hanger mud line"
    HANGER_TUBING = "hanger tubing"
    HEAVY_WEIGHT_DRILL_PIPE = "heavy weight drill pipe"
    HEAVY_WEIGHT_DRILL_PIPE_LH = "heavy weight drill pipe LH"
    JAR = "jar"
    JUNK_BASKET = "junk basket"
    JUNK_BASKET_REVERSE_CIRCULATION = "junk basket reverse circulation"
    KELLY = "kelly"
    KEYSEAT_WIPER_TOOL = "keyseat wiper tool"
    LANDING_FLOAT_COLLAR = "landing float collar"
    LEAD_IMPRESSION_BLOCK = "lead impression block"
    LINER = "liner"
    LOGGING_WHILE_DRILLING_TOOL = "logging while drilling tool"
    MAGNET = "magnet"
    MILL_CASING_CUTTING = "mill casing cutting"
    MILL_DRESS = "mill dress"
    MILL_FLAT_BOTTOM = "mill flat bottom"
    MILL_HOLLOW = "mill hollow"
    MILL_PACKER_PICKER_ASSEMBLY = "mill packer picker assembly"
    MILL_PILOT = "mill pilot"
    MILL_POLISH = "mill polish"
    MILL_SECTION = "mill section"
    MILL_TAPER = "mill taper"
    MILL_WASHOVER = "mill washover"
    MILL_WATERMELON = "mill watermelon"
    MILLOUT_EXTENSION = "millout extension"
    MOTOR = "motor"
    MOTOR_INSTRUMENTED = "motor instrumented"
    MOTOR_STEERABLE = "motor steerable"
    MULE_SHOE = "mule shoe"
    MULTILATERAL_HANGER_RUNNING_TOOL = "multilateral hanger running tool"
    MWD_HANG_OFF_SUB = "MWD hang off sub"
    MWD_PULSER = "MWD pulser"
    NON_MAGNETIC_COLLAR = "non-magnetic collar"
    NON_MAGNETIC_STABILIZER = "non-magnetic stabilizer"
    OTHER = "other"
    OVERSHOT = "overshot"
    OVERSHOT_LH = "overshot LH"
    OVERSIZE_LIP_GUIDE_OVERSHOT = "oversize lip guide overshot"
    PACKER = "packer"
    PACKER_RETRIEVE_TT_SQUEEZE = "packer retrieve TT squeeze"
    PACKER_RTTS = "packer RTTS"
    PACKER_STORM_VALVE_RTTS = "packer storm valve RTTS"
    PIPE_CUTTER = "pipe cutter"
    POLISHED_BORE_RECEPTACLE = "polished bore receptacle"
    PORTED_STINGER = "ported stinger"
    PREPACKED_SCREENS = "prepacked screens"
    REAMER = "reamer"
    REVERSING_TOOL = "reversing tool"
    RISER_HIGH_PRESSURE = "riser high pressure"
    RISER_MARINE = "riser marine"
    RISER_PRODUCTION = "riser production"
    ROTARY_STEERING_TOOL = "rotary steering tool"
    RUNNING_TOOL = "running tool"
    SAFETY_JOINT = "safety joint"
    SAFETY_JOINT_LH = "safety joint LH"
    SCAB_LINER_BIT_GUIDE = "scab liner bit guide"
    SCRAPER = "scraper"
    SCRATCHERS = "scratchers"
    SLOTTED_LINER = "slotted liner"
    SPEAR = "spear"
    STABILIZER = "stabilizer"
    STABILIZER_INLINE = "stabilizer inline"
    STABILIZER_NEAR_BIT = "stabilizer near bit"
    STABILIZER_NEAR_BIT_ROLLER_REAMER = "stabilizer near bit roller reamer"
    STABILIZER_NON_ROTATING = "stabilizer non-rotating"
    STABILIZER_STEERABLE = "stabilizer steerable"
    STABILIZER_STRING = "stabilizer string"
    STABILIZER_STRING_ROLLER_REAMER = "stabilizer string roller reamer"
    STABILIZER_TURBO_BACK = "stabilizer turbo back"
    STABILIZER_VARIABLE_BLADE = "stabilizer variable blade"
    STAGE_CEMENT_COLLAR = "stage cement collar"
    SUB_BAR_CATCHER = "sub-bar catcher"
    SUB_BENT = "sub-bent"
    SUB_BIT = "sub-bit"
    SUB_BUMPER = "sub-bumper"
    SUB_CATCHER = "sub-catcher"
    SUB_CIRCULATION = "sub-circulation"
    SUB_CONE = "sub-cone"
    SUB_CROSSOVER = "sub-crossover"
    SUB_DART = "sub-dart"
    SUB_FILTER = "sub-filter"
    SUB_FLOAT = "sub-float"
    SUB_JETTING = "sub-jetting"
    SUB_JUNK = "sub-junk"
    SUB_ORIENTING = "sub-orienting"
    SUB_PORTED = "sub-ported"
    SUB_PRESSURE_RELIEF = "sub-pressure relief"
    SUB_PUMP_OUT = "sub-pump out"
    SUB_RESTRICTOR = "sub-restrictor"
    SUB_SAVER = "sub-saver"
    SUB_SHOCK = "sub-shock"
    SUB_SIDE_ENTRY = "sub-side entry"
    SUB_STOP = "sub-stop"
    SURFACE_PIPE = "surface pipe"
    TAPER_TAP = "taper tap"
    TAPER_TAP_LH = "taper tap LH"
    THRUSTER = "thruster"
    TIEBACK_POLISHED_BORE_RECEPTACLE = "tieback polished bore receptacle"
    TIEBACK_STINGER = "tieback stinger"
    TUBING = "tubing"
    TUBING_CONVEYED_PERFORATING_GUN = "tubing-conveyed perforating gun"
    TURBINE = "turbine"
    UNKNOWN = "unknown"
    WASHOVER_PIPE = "washover pipe"
    WHIPSTOCK = "whipstock"
    WHIPSTOCK_ANCHOR = "whipstock anchor"
