from __future__ import annotations
from dataclasses import dataclass, field
from typing import List, Optional
from witsml20.abstract_object import AbstractObject
from witsml20.data_object_reference import DataObjectReference
from witsml20.length_measure import LengthMeasure
from witsml20.tubular_assembly import TubularAssembly
from witsml20.tubular_component import TubularComponent

__NAMESPACE__ = "http://www.energistics.org/energyml/data/witsmlv2"


@dataclass
class Tubular(AbstractObject):
    """Used to capture information about the configuration of a drill string.

    For information about a use of this configuration, See the BhaRun
    object . This object is uniquely identified within the context of
    one wellbore object.

    :ivar type_tubular_assy: Type of tubular assembly.
    :ivar valve_float: Is float valve present?  Values are "true" (or
        "1") and "false" (or "0").
    :ivar source_nuclear: Is nuclear tool present?  Values are "true"
        (or "1") and "false" (or "0").
    :ivar dia_hole_assy: Maximum hole size generated by the assembly.
    :ivar tubular_component:
    :ivar wellbore:
    """
    class Meta:
        namespace = "http://www.energistics.org/energyml/data/witsmlv2"

    type_tubular_assy: Optional[TubularAssembly] = field(
        default=None,
        metadata={
            "name": "TypeTubularAssy",
            "type": "Element",
            "required": True,
        }
    )
    valve_float: Optional[bool] = field(
        default=None,
        metadata={
            "name": "ValveFloat",
            "type": "Element",
        }
    )
    source_nuclear: Optional[bool] = field(
        default=None,
        metadata={
            "name": "SourceNuclear",
            "type": "Element",
        }
    )
    dia_hole_assy: Optional[LengthMeasure] = field(
        default=None,
        metadata={
            "name": "DiaHoleAssy",
            "type": "Element",
        }
    )
    tubular_component: List[TubularComponent] = field(
        default_factory=list,
        metadata={
            "name": "TubularComponent",
            "type": "Element",
        }
    )
    wellbore: Optional[DataObjectReference] = field(
        default=None,
        metadata={
            "name": "Wellbore",
            "type": "Element",
            "required": True,
        }
    )
